/** 产品模块 */
declare namespace Product {
  /** 产品列表搜索 */
  interface ProductBase {
    productName: string; // 产品名称
  }

  /** 产品列表 */
  interface ProductListRow extends ProductBase {
    productCode: string; // 产品编码
    productName: string; // 产品名称
  }

  /** 产品详情 */
  interface ProductDetail extends ProductBase {
    beginTime: string; // 开始时间
    commercialAccountType: string; // 购买账户类型
    createBy: string; // 创建者
    createTime: string; // 创建时间
    createdTime: string; // 创建时间
    earningCalculateType: string; // 产品收益计算类型
    earningsRate: string; // 年化收益率
    endTime: string; // 结束时间
    expiryDate: string; // 到期日期
    guaranteedRate: string; // 保证利率
    isAsc: string; // 排序的方向
    isPaidOneTime: string; //	能否一次性缴费
    isReceiveOneTime: string; // 能否一次性领取
    isRecommended: string; //	是否推荐
    modifiedTime: string; //	修改时间
    orderByColumn: string; //	排序列
    pageNum: string; //	当前页数
    pageSize: string; //	分页大小
    paidRegularlyRange: string; // 定期缴费区间
    productCashType: string; //	产品现金流类别
    productCode: string; //	产品编码
    productName: string; //	产品名称
    productType: string; //	产品类型
    purchaseAccountType: string; //	购买账户类型
    purchaseRestrictions: string; //	购买限制条款
    purchaseType: string; //	购买方式
    receiveInfo: string; //	领取信息
    replacementProductCode: string; // 替代产品
    riskLevel: string; //	风险等级
    searchValue: string; //	搜索值
    updateBy: string; // 更新者
    updateTime: string; // 更新时间
    volatilities: string; // 预期波动率
  }
}
