import { request } from '../request';

/** 系统 -> 获取菜单列表(树) */
export function fetchGetMenuList() {
  return request.post('/menu/pc/v1/treeselect', {});
}

/**
 * 添加菜单
 * @param menuType - 菜单类型
 * @param menuName - 菜单名称
 * @param orderNum - 排序
 * @param visible - 显隐
 * @param status - 状态
 * @param icon - 图标
 */
export function fetchAddMenu(params: System.AddMenuForm) {
  return request.post('/menu/pc/v1/add', params);
}

/**
 * 删除菜单
 * @path menuId - 菜单唯一标识
 */
export function fetchDelMenu<T>(menuId: T) {
  return request.post(`/menu/pc/v1/remove/${menuId}`);
}

/** 编辑菜单 */
export function fetchEditMenu(params: System.AddMenuForm) {
  return request.post('/menu/pc/v1/edit', params);
}

/** 系统 -> 获取用户列表 */
export function fetchGetUserList<T>(params: T) {
  return request.post(`/user/pc/v1/list`, params);
}

/**
 * 添加用户
 * @param params
 * @returns
 */
export function fetchAddUser(params: System.UserForm) {
  return request.post('/user/pc/v1/add', params);
}

/** 修改用户详情 */
export function fetchEditUser(params: System.UserForm) {
  return request.post('/user/pc/v1/edit', params);
}

/** 获取用户详情 */
export function fetchGetUserDetail(userId: any) {
  return request.post(`/user/pc/v1/get_sys_user_detail`, { userId });
}

/** 重置用户密码 */
export function fetchResetUserPwd(params: any) {
  return request.post(`/user/pc/v1/reset_password`, params);
}

/** 删除用户 */
export function fetchDelUser<T>(userIds: T) {
  return request.post(`/user/pc/v1/delete_sys_user`, { userIds });
}

/** 系统 --> 获取部门（树） */
export function fetchGetDetpTree() {
  return request.post('/dept/pc/v1/treeselect', {});
}
/** 新增部门 */
export function fetchAddDept(params: System.DeptForm) {
  return request.post('/dept/pc/v1/add', params);
}
/** 修改部门 */
export function fetchEditDept(params: System.DeptForm) {
  return request.post('/dept/pc/v1/edit', params);
}
/** 删除部门 */
export function fetchDelDept<T>(deptId: T) {
  return request.post(`/dept/pc/v1/delete`, { deptId });
}
/** 获取部门详情 */
export function fetchGetDeptDetail<T>(deptId: T) {
  return request.post(`/dept/pc/v1/get`, { deptId });
}

/** 系统 --> 获取角色列表 */
export function fetchGetRoles(pageNum?: number, pageSize?: number, roleName?: string) {
  return request.post(`/role/pc/v1/list`, {
    pageNum,
    pageSize,
    roleName
  });
}

/** 删除角色 */
export function fetchDelRole<T>(roleIds: T) {
  return request.post(`/role/pc/v1/delete_role`, { roleIds });
}

/** 获取角色详情 */
export function fetchGetRoleDetail<T>(roleId: T) {
  return request.post(`/role/pc/v1/get_role_detail`, { roleId });
}

/** 新增角色 */
export function fetchAddRole(params: System.RoleForm) {
  return request.post('/role/pc/v1/add_role', params);
}

/** 获取角色菜单详情 */
export function fetchGetRoleMenuDetail<T>(roleId: T) {
  return request.post(`/menu/pc/v1/getTree/${roleId}`);
}

/** 获取角色部门详情 */
export function fetchGetRoleDeptDetail<T>(roleId: T) {
  return request.post(`/system/dept/roleDeptTreeselect`, { roleId });
}

/** 修改角色 */
export function fetchEditRole(params: System.RoleForm) {
  return request.post('/role/pc/v1/edit', params);
}
/** 修改角色的部门权限 */
export function fetchEditRolesDept(params: any) {
  return request.post('/role/pc/v1/data_scope', params);
}
