import { mockRequest, request } from '../request';

/**
 * 获取登录的code
 * @returns - 返回img&uuid值表示获取成功
 */
export function getLoginCode() {
  return request.post<ApiAuth.LoginCode>('/captcha/pc/v1/captchaImage');
}

/**
 * 登录
 * @param userName - 用户名
 * @param pwd - 密码
 * @param uuid - login code 的id
 * @param code - login code
 */
export function fetchLogin(userName: string, pwd: string, uuid: string, code: string) {
  const params = {
    username: userName,
    password: pwd,
    uuid,
    code
  };
  return request.post<ApiAuth.Token>('/login/pc/v1/login', {
    loginBody: window.btoa(JSON.stringify(params))
  });
}

/**
 * 企微登录
 * @param code
 * @returns
 */
export function fetchWxLogin(code: string) {
  return request.post('/login/pc/v1/wechat/login', { code });
}

/** 获取用户信息 */
export function fetchUserInfo() {
  return request.post('/login/pc/v1/getInfo');
}

/**
 * 获取用户路由数据
 * @param userId - 用户id
 * @description 后端根据用户id查询到对应的角色类型，并将路由筛选出对应角色的路由数据返回前端
 */
export function fetchUserRoutes() {
  return request.post<ApiRoute.Route>('/login/pc/v1/getRouters');
}
