import type { App } from 'vue';
import { createRouter, createWebHistory } from 'vue-router';
import { transformAuthRoutesToVueRoutes } from '@/utils';
import { constantRoutes } from './routes';
import { scrollBehavior } from './helpers';
import { createRouterGuard } from './guard';

const history = createWebHistory('/sdream-admin-fe');

export const router = createRouter({
  history,
  routes: transformAuthRoutesToVueRoutes(constantRoutes),
  scrollBehavior
});

export async function setupRouter(app: App) {
  app.use(router);
  createRouterGuard(router);
  await router.isReady();
}

export * from './routes';
export * from './modules';
