export default function useDownload() {
  function downloadFile(arraybuffer: Blob, fileName?: string, fileType?: string) {
    const blob = new Blob([arraybuffer], { type: 'application/vnd.ms-excel' }); // for .xlsx files
    const link = document.createElement('a');
    link.download = `${fileName ?? '数据表格'}.${fileType ?? 'xls'}`;
    link.style.display = 'none';
    link.href = URL.createObjectURL(blob);
    document.body.appendChild(link);
    link.click();
    URL.revokeObjectURL(link.href); // 释放URL 对象
    document.body.removeChild(link);
  }
  return {
    downloadFile
  };
}
