import { defineConfig, loadEnv } from 'vite';
import { resolvePath, viteDefine, setupVitePlugins, createViteProxy, createViteBuild } from './build';

/**
 * https://www.kuxiaoxin.com/archives/40
 * loadEnv:
 * 检查process.cwd()路径下.env.development.local、.env.development、.env.local、.env这四个环境文件。
 * 输出NODE_ENV和VITE_开头的键值对。
 * VITE_开头的键值对后面的不会覆盖前面的。
 * NODE_ENV的值后面的会覆盖前面的。
 */
export default defineConfig(configEnv => {
  const viteEnv = loadEnv(configEnv.mode, process.cwd()) as ImportMetaEnv;
  const viteCommand = configEnv.command;
  const vitePath = resolvePath('./', import.meta.url);
  return {
    base: '/chonglin-admin/',
    resolve: {
      alias: {
        '~': vitePath.root,
        '@': vitePath.src
      }
    },
    define: viteDefine,
    plugins: setupVitePlugins(configEnv, vitePath.src, viteEnv),
    css: {
      preprocessorOptions: {
        scss: {
          additionalData: `@use "./src/styles/scss/global.scss" as *;`
        }
      }
    },
    server: {
      host: '0.0.0.0',
      port: 9191,
      open: true,
      proxy: createViteProxy(viteEnv)
    },
    build: createViteBuild(viteEnv, viteCommand)
  };
});
