import { cloneDeep } from 'lodash-es';
/** 设置对象数据 */
export function objectAssign<T extends Record<string, any>>(target: T, source: Partial<T>) {
  Object.assign(target, source);
}

/** 对象净化 */
export function objectClean<T extends Record<string, any>>(source: T) {
  const result = cloneDeep(source);
  Object.keys(source).forEach(key => {
    if ([undefined, '', null].includes(source[key])) delete result[key];
  });
  return result;
}
