/** 用户相关模块 */
declare namespace Auth {
  /**
   * 用户角色类型(前端静态路由用角色类型进行路由权限的控制)
   * - super: 超级管理员(该权限具有所有路由数据)
   * - admin: 管理员
   * - test: 测试
   * - normal: 普通用户
   */
  type RoleType = 'super' | 'admin' | 'test' | 'normal';

  /** 用户信息 */
  interface UserInfo {
    /** 用户id */
    userId: number;
    /** 用户名 */
    username: string;
    /** 用户手机号 */
    phonenumber: string;
    /** 三级部门名称 */
    deptName: string;
    /** 三级部门id */
    deptId: number;
    /** 二级部门id */
    parentDeptId: number;
    /** 二级部门名称 */
    parentDeptName: string;
    /** 用户信息 */
    user?: any;
    nickName?: string;
  }

  /** 登录的code */
  interface LoginCode {
    captchaOnOff: boolean;
    code: number;
    img: string;
    msg: string;
    uuid: string;
  }
}

/** 系统模块相关 */
declare namespace System {
  /** 添加菜单的表单 */
  interface AddMenuForm {
    menuType: string;
    menuName: string;
    icon: string;
    orderNum: number;
    visible?: string;
    status: string;
    [propsName: string]: any;
  }

  /** 菜单表格的行 */
  interface MenuTableRow {
    menuType: string;
    createTime: string;
    component: string;
    icon: string;
    menuId: number;
    menuName: string;
    orderNum: number;
    parentId: number;
    path: string;
    singleLayout?: string;
    status?: string;
    visible?: string;
    children?: MenuTableRow[];
  }

  /** 用户部门 */
  interface UserDept {
    deptName: string;
  }
  /** 用户表格的行 */
  interface UserTableRow {
    userId: number;
    dept: UserDept;
    [propsName: string]: any;
  }

  /** 用户表单 */
  interface UserForm {
    nickName: string;
    userName: string;
    email: string;
    sex: string;
    password: string;
    status: string;
    deptId: string;
    remark: string;
    phonenumber: string;
    roleIds: string[];
    userType: string;
  }

  /** 部门表格的行 */
  interface DeptTableRow {
    deptId: number;
    deptName: string;
    [propsName: string]: any;
  }

  /** 部门表单 */
  interface DeptForm {
    deptName: string;
    orderNum: number;
    leader: string;
    phone: string;
    status: string;
  }
  /** 角色表格的行 */
  interface RoleTableRow {
    roleId: number;
    [propsName: string]: any;
  }

  /** 部门表单 */
  interface RoleForm {
    roleName: string;
    roleDesc: string;
    // roleKey: string;
    // roleSort: number;
    dataScope?: string;
    menuIds?: number[];
    status: string;
  }
}
