/** 后端返回的用户权益相关类型 */
declare namespace ApiAuth {
  /** 返回的token和刷新token */
  interface Token {
    [x: string]: any;
  }
  /** 返回的用户信息 */
  type UserInfo = Auth.UserInfo;

  /** 返回的登录验证码 */
  type LoginCode = Auth.LoginCode;
}

/** 后端返回的路由相关类型 */
declare namespace ApiRoute {
  /** 后端返回的路由数据类型 */
  type Route = AuthRoute.Route[];
}

/** 分页 */
interface Pagination {
  /** 页号 */
  pageNum: number;
  /** 页尺寸 */
  pageSize: number;
}

/** 内容配置 */
declare namespace ApiDiscover {
  /** 查询banner列表-查询参数 */
  interface BannerListQueryParams extends Pagination {
    /** banner名称 */
    bannerName: string;
    /** banner状态 */
    bannerStatus: string | null;
    /** 更新时间-end */
    endUpdateTime: string;
    /** 更新时间-start */
    startUpdateTime: string;
    topFlag: number | null;
    scene: string | null;
  }
}

/** 客户查询 */
declare namespace ApiCustomer {
  /** 查询客户管理-查询参数 */
  interface CustomerListQueryParams extends Pagination {
    /** 客户姓名 */
    realName: string;
  }

  /** 查询客户管理-查询参数 */
  interface CustomerCalculationListQueryParams extends Pagination {
    /** 客户d */
    userId: string;
    /** 开始时间 */
    beginDate: string;
    /** 结束时间 */
    endDate: string;
    /** 测算类型 */
    calculationType;
  }
}

/** 产品查询 */
declare namespace ApiProduct {
  /** 查询产品管理-查询参数 */
  interface ProductListQueryParams extends Pagination {
    /** 客户姓名 */
    productName: string;
  }
}
