import { request } from '../request';

/**
 * 查询 产品类型 列表
 */
export function fetchQueryProductTypeList() {
  return request.post(`/product/pc/v1/query_product_type_list`);
}


/**
 * 查询 产品 列表
 */
export function fetchQueryProductList<T>(params: T) {
  return request.post(`/product/pc/v1/query_list`, params);
}


/**
 * 查询 产品 列表
 */
export function fetchQueryProductDetail<T>(params: T) {
  return request.post(`/product/pc/v1/query_detail`, params);
}


/**
 * 新增 产品 
 */
export function fetchAddProduct<T>(params: T) {
  return request.post(`/product/pc/v1/add_product`, params);
}

/**
 * 停用 产品 
 */
export function fetchDeactivateProduct<T>(params: T) {
  return request.post(`/product/pc/v1/deactivate_product`, params);
}

/**
 * 删除 产品 
 */
export function fetchDeleteProduct<T>(params: T) {
  return request.post(`/product/pc/v1/delete_product`, params);
}

/**
 * 新增 产品文档
 */
export function fetchAddProductDoc<T>(params: T) {
  return request.post(`/product/pc/v1/add_document`, params);
}

/**
 * 新增 产品文档
 */
export function fetchUpdateProductDoc<T>(params: T) {
  return request.post(`/product/pc/v1/update_document`, params);
}

/**
 * 删除 产品文档
 */
export function fetchDeleteProductDoc<T>(params: T) {
  return request.post(`/product/pc/v1/delete_document`, params);
}

/**
 * 提交 产品文档
 */
export function fetchSubmitProductDoc<T>(params: T) {
  return request.post(`/product/pc/v1/submit_document`, params);
}

/**
 * 审核 产品文档
 */
export function fetchAuditProductDoc<T>(params: T) {
  return request.post(`/product/pc/v1/audit_document`, params);
}


/**
 * 撤回解析 产品文档
 */
export function fetchBackOffDoc<T>(params: T) {
  return request.post(`/product/pc/v1/analysis_backOff_document`, params);
}

/**
 * 重新解析 产品文档
 */
export function fetchAnalysisDoc<T>(params: T) {
  return request.post(`/product/pc/v1/analysis_document`, params);
}
