const system: AuthRoute.Route = {
  name: 'system',
  path: '/system',
  component: 'basic',
  meta: {
    title: '系统管理',
    icon: 'fluent:app-store-24-regular',
    order: 3
  },
  children: [
    {
      name: 'system_dept',
      path: '/system/dept',
      component: 'self',
      meta: {
        title: '部门管理',
        requiresAuth: true,
        icon: 'ic:baseline-radio-button-checked'
      }
    },
    {
      name: 'system_menu',
      path: '/system/menu',
      component: 'self',
      meta: {
        title: '菜单管理',
        requiresAuth: true,
        icon: 'ic:baseline-radio-button-checked'
      }
    },
    {
      name: 'system_user',
      path: '/system/user',
      component: 'self',
      meta: {
        title: '用户管理',
        requiresAuth: true,
        icon: 'ic:baseline-radio-button-checked'
      }
    },
    {
      name: 'system_role',
      path: '/system/role',
      component: 'self',
      meta: {
        title: '角色管理',
        requiresAuth: true,
        icon: 'ic:baseline-radio-button-checked'
      }
    }
  ]
};

export default system;
