import type { BuildOptions } from 'vite';
/** vite打包 */
export function createViteBuild(viteEnv: ImportMetaEnv, viteCommand: string) {
  const isProd = viteEnv.VITE_ENV_TYPE === 'prod';
  const isBuild = viteCommand === 'build';
  const build: Record<string, any | BuildOptions> = {
    outDir: 'sdream-admin-fe',
    brotliSize: false,
    sourcemap: false,
    chunkSizeWarningLimit: 500,
    minify: 'terser', // 默认 esbuild
    terserOptions: {
      compress: {
        drop_console: isBuild && isProd,
        drop_debugger: isBuild && isProd
      }
    },
    rollupOptions: {
      output: {
        manualChunks(id: string) {
          if (id.includes('node_modules')) {
            return id.toString().split('node_modules/')[1].split('/')[0].toString();
          }
          return null;
        },
        chunkFileNames: (chunkInfo: Record<string, any>) => {
          const facadeModuleId = chunkInfo.facadeModuleId ? chunkInfo.facadeModuleId.split('/') : [];
          const fileName = facadeModuleId[facadeModuleId.length - 2] || '[name]';
          return `js/${fileName}/[name].[hash].js`;
        }
      }
    }
  };
  return build;
}
