import type { Router, RouteLocationNormalized, NavigationGuardNext } from 'vue-router';
import { routeName } from '@/router';
import { useRouteStore } from '@/store';
import { getToken } from '@/utils';

/**
 * 动态路由
 */
export async function createDynamicRouteGuard(
  to: RouteLocationNormalized,
  _from: RouteLocationNormalized,
  next: NavigationGuardNext,
  router: Router
) {
  const route = useRouteStore();
  const isLogin = Boolean(getToken());

  // 初始化权限路由
  if (!route.isInitedAuthRoute) {
    // 未登录情况下直接回到登录页，登录成功后再加载权限路由
    if (!isLogin) {
      if (to.name === routeName('login')) {
        next();
      } else {
        next({ name: routeName('login') });
      }
      return false;
    }
    await route.initUserInfo();
    await route.initAuthRoute(router);

    if (to.name === routeName('not-found-page')) {
      // 动态路由没有加载导致被not-found-page路由捕获，等待权限路由加载好了，回到之前的路由
      next({ path: to.fullPath, replace: true, query: to.query });
      return false;
    }
  }

  // 权限路由已经加载，仍然未找到，重定向到not-found
  if (to.name === routeName('not-found-page')) {
    if (route.menus.length === 0) {
      next({ name: 'no-permission', path: 'no-permission', replace: true });
    } else {
      next({ name: 'not-found', path: 'not-found', replace: true });
    }
    return false;
  }

  return true;
}
