import {
  CALCULATION_PENSION_CODE,
  CALCULATION_ANNUITY_CODE,
  CALCULATION_CONSUME_CODE,
  CALCULATION_WEALTH_CODE,
  CALCULATION_GAP_CODE,
  CALCULATION_PLAN_CODE,
  CALCULATION_TRIAL_CODE
} from '@/const';

/**
 * 过滤工具名称
 * @param  calculationType 测算类型
 * @returns 工具名称
 */
export const filterCalculationType = (calculationType: string) => {
  switch (calculationType) {
    case CALCULATION_PENSION_CODE:
      return '基本养老金测算';
    case CALCULATION_ANNUITY_CODE:
      return '职业养老金测算';
    case CALCULATION_CONSUME_CODE:
      return '消费健康比一比';
    case CALCULATION_WEALTH_CODE:
      return '财务健康测一测';
    case CALCULATION_GAP_CODE:
      return '养老缺口测算';
    case CALCULATION_PLAN_CODE:
      return '养老计划制定';
    case CALCULATION_TRIAL_CODE:
      return '产品试算';
    default:
      return '';
      break;
  }
};
