import type { App, Directive } from 'vue';
import { useAuth } from '@/hooks';

const { handlePermission } = useAuth();

export default function setupPermissionsDirective(app: App) {
  const permissionsDirective: Directive<HTMLElement, string | undefined> = {
    mounted(el: HTMLElement, binding) {
      handlePermission(el, binding);
    }
  };

  app.directive('permission', permissionsDirective);
}
