export function debounce<T extends(...args: any[]) => any>(func: T, wait: number): T {
  let timeout: NodeJS.Timeout;
 
  // 返回新的函数，防止原函数被直接调用
  return function (this: any, ...args: Parameters<T>) {
    clearTimeout(timeout);
    timeout = setTimeout(() => {
      // 使用 apply 或 call 来确保函数内的 this 指向正确
      func.apply(this, args);
    }, wait);
  } as any as T;
}