/**
 * @description: 常见问题
 */
export interface QuestionConfigItem {
  createBy: string
  createTime: string
  question: string
  questionId: string
  showOrder: number
  updateBy: string
  updateTime: string
}

interface AiAskProvideKeyType {
  messages: Ref<ChatMessageItem[]>
  sendMessage: (query: string) => Promise<boolean>
  userConsultCounter: Ref<UserConsultCounter | undefined>
  userInfo: any
  loading: Ref<boolean>
  sendLoading: Ref<boolean>
  aiTypeItLoading: Ref<boolean>
  historyMessages: Ref<any[]>
  historyTotal: Ref<number>
  nextPageHistoryMessages: () => void
  toggleAiTypeItLoading: (val: boolean) => void
}

export const AiAskProvideKey: InjectionKey<AiAskProvideKeyType> = Symbol('AiAskProvideKey')

export const AiChatContentProvideKey: InjectionKey<{
  scrollToBottom: () => void
}> = Symbol('AiChatContentProvideKey')

/**
 * @description: 用户咨询次数
 */
export interface UserConsultCounter {
  maxConsultNum: number
  consultNum: number
  vipFlag: boolean
}

/**
 * @description 聊天消息类型
 */
export type ChatMessageRole = 'user' | 'ai' | 'system'

/**
 * @description 聊天消息
 */
export interface ChatMessageItem {
  role: ChatMessageRole
  content: string
  status?: 'sending' | 'success' | 'fail' | undefined
}

/**
 * @description: 查询咨询配置
 */
export interface QueryConsultConfig {
  body: Record<string, any>
  chatUrl: string
}
