/*
 * @Author: weiyudumei wangxu9681@126.com
 * @Date: 2024-07-30 14:51:00
 * @LastEditors: weiyudumei wangxu9681@126.com
 * @LastEditTime: 2024-07-31 11:01:33
 * @FilePath: /guomin-jianyan-h5-fe/src/router/index.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import 'vant/es/toast/style'
import { createRouter, createWebHistory } from 'vue-router'
import { helperHandleAuth, helperHandleAuthTemp } from './helpers/auth'

import Demo from '@/pages/demo/index.vue'

const routes = [
  { path: '', component: () => import('@/pages/index.vue'), meta: { title: '晓得' } },
  { path: '/demo', component: Demo, meta: { title: '晓得' } },
  { path: '/home', component: () => import('@/pages/home/index.vue'), meta: { title: '晓得' } },
  { path: '/more', component: () => import('@/pages/more/index.vue'), meta: { title: '晓得' } },
  { path: '/collection', component: () => import('@/pages/collection/index.vue'), meta: { title: '收藏' } },
  { path: '/agreement', component: () => import('@/pages/agreement/index.vue'), meta: { title: '协议' } },
]

const router = createRouter({
  history: createWebHistory('/sdream-h5/'),
  routes,
})

helperHandleAuthTemp(router)

export default router
