export function useStorage() {
  const storageKeyForToken = '__TOKEN__'

  function getToken() {
    return window.localStorage.getItem(storageKeyForToken)
  }

  function setToken(token: string) {
    window.localStorage.setItem(storageKeyForToken, token)
  }

  function clear() {
    window.localStorage.clear()
  }

  return {
    getToken,
    setToken,
    clear,
  }
}
