/* eslint-disable node/prefer-global/process */
import http from '../utils/request'

/**
 * 查询三方用户信息接口
 * @returns
 */
export function fetchGetThirdUserInfo(code: string) {
  const params = {
    code,
    appId: process.env.VITE_APP_WECHAT_APP_ID,
    subAppId: process.env.VITE_APP_WECHAT_SUB_APP_ID,
  }
  return http.post('/user/api/login/mobile/v1/get_third_user_info', params)
}

/**
 * 获取用户信息
 * @returns
 */
export function fetchGetUserInfo() {
  return http.post('/user/api/user_center/mobile/v1/get_user')
}

/**
 * 登录
 * @returns
 */
export function fetchLogin(loginCode: string) {
  return http.post('/user/api/login/mobile/v1/login', {
    loginCode,
    appId: process.env.VITE_APP_WECHAT_APP_ID,
    subAppId: process.env.VITE_APP_WECHAT_SUB_APP_ID,
  })
}

/**
 * 用户业务操作公共接口
 * 	操作类型 01：用户协议已读通知
 * @returns
 */
export function fetchCommonOperate(operateType: string) {
  return http.post('/user/api/user_center/mobile/v1/common_operate', {
    operateType,
  })
}

/**
 * 登录
 * @returns
 */
export function fetchLoginByUid(uid: string) {
  return http.post('/user/api/login/mobile/v1/guest/login', {
    userId: uid,
  })
}