/*
 * @Author: weiyudumei wangxu9681@126.com
 * @Date: 2024-05-20 10:56:58
 * @LastEditors: weiyudumei wangxu9681@126.com
 * @LastEditTime: 2024-06-24 15:10:47
 * @FilePath: /guomin-jianyan-h5-fe/src/api/conversation.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import http from '../utils/request'

/**
 * 查询场景配置接口
 * @params { * }
 */
export function fetchSceneConfig() {
  return http.post('/conversation/api/scene_config/mobile/v1/query_scene_config', {})
}

/**
 * 查询当前会话
 * @params { * }
 */
export function fetchCurrentConversation() {
  return http.post('/conversation/api/conversation/mobile/v1/get_user_conversation_session', {})
}

/**
 * 创建会话
 * @params { * }
 */
export function createConversation() {
  return http.post('/conversation/api/conversation/mobile/v1/create_conversation', {})
}

/**
 * 查询用户问答历史
 * @params { * }
 */
export function fetchUserQaRecordRage(data: object) {
  return http.post('/conversation/api/conversation/mobile/v1/query_user_qa_record_list', data)
}


/**
 * 提交问题
 * @params
 */
export function submitQuestionStream(data: object) {
  return http.post('/conversation/api/conversation/mobile/v1/submit_question_stream', data, {
    responseType: 'stream',
  })
}

/**
 * 查询用户历史会话列表
 * @params
 */
export function queryUserConversationPage(data: object) {
  return http.post('/conversation/api/conversation/mobile/v1/query_user_conversation_page', data, {
    responseType: 'stream',
  })
}

/**
 * 删除用户历史会话
 * @params
 */
export function deleteUserConversation(data: object) {
  return http.post('/conversation/api/conversation/mobile/v1/delete_user_conversation', data, {
    responseType: 'stream',
  })
}

/**
 * 停止问答
 * @param params
 * @returns
 */
export function fetchTerminateQuestion(params: any) {
  return http.post('/conversation/api/conversation/mobile/v1/terminate_question', params)
}







