import http from '../utils/request'

/**
 * 查询推荐问题
 * @param conversationId
 * @returns
 */
export function fetchQueryRecommendQuestion(conversationId: string, recordId: string) {
  return http.post('/conversation/api/conversation/mobile/v1/query_recommend_question', {
    conversationId,
    recordId,
  })
}

/**
 * 查询用户收藏列表
 * @param params
 * @returns
 */
export function fetchQueryCollectionList<T>(params: T) {
  return http.post('/conversation/api/collection/mobile/v1/query_user_collection_page', params)
}

/**
 * 提交收藏
 * @param recordId
 * @returns
 */
export function fetchSubmitCollection(recordId: string) {
  return http.post('/conversation/api/collection/mobile/v1/submit_collection', { recordId })
}

/**
 * 删除收藏
 * @param collectionIdList
 * @returns
 */
export function fetchDelCollection(collectionIdList: string[]) {
  return http.post('/conversation/api/collection/mobile/v1/delete_user_collection', { collectionIdList })
}

/**
 * 取消收藏
 * @param recordId
 * @returns
 */
export function fetchCancelCollection(recordId: string) {
  return http.post('/conversation/api/collection/mobile/v1/cancel_user_collection', { recordId })
}

/**
 * 获取文档链接
 * @param recordId
 * @returns
 */
export function fetchGetDocumentLink(docId: string) {
  return http.post('/conversation/api/conversation/mobile/v1/get_document', {
    ossType: 'private',
    docId,
  })
}

/**
 * 获取文档链接s
 * @param recordId
 * @returns
 */
export function fetchGetDocumentLinks(docIdList: string[]) {
  return http.post('/conversation/api/conversation/mobile/v1/query_batch_document', {
    ossType: 'private',
    docIdList,
  })
}

/**
 * 获取反馈配置
 * 场景：01：用户问答反馈
 * @param recordId
 * @returns
 */
export function fetchGetFeedbackConfig() {
  return http.post('/conversation/api/feedback/mobile/v1/get_config', {
    scene: '01',
  })
}

/**
 * 提交反馈
 * feedbackStatus	问答反馈状态 00：初始（取消） 01：点赞 02：点踩
 * recordId	 会话问答ID
 * scene 场景：01：用户问答反馈
 * content	反馈内容
 * @param params
 * @returns
 */
export function fetchSubmitFeedback(params: any) {
  return http.post('/conversation/api/feedback/mobile/v1/submit_feedback', {
    ...params,
    scene: '01',
  })
}
