/// <reference types="vite/client" />

declare module '*.vue' {
  import type { DefineComponent } from 'vue'

  const component: DefineComponent<object, object, any>
  export default component
}

declare let wx: any

declare module 'echarts' {
  const echarts: any
  export default echarts
}

declare module 'vue-wechat-title'{
  const VueWechatTitle: any
  export default VueWechatTitle
}

interface ImportMetaEnv {
  // 当前环境
  readonly NODE_ENV: NodeEnv
  // 项目请求地址
  readonly VUE_APP_BASE_API: string
}

type NodeEnv = 'dev' | 'sit' | 'uat' | 'pre' | 'prod'

interface ImportMeta {
  readonly env: ImportMetaEnv
}
