export function setLocal(key: string, value: any) {
  window.localStorage.setItem(key, JSON.stringify(value))
}

export function getLocal(key: string) {
  const json = window.localStorage.getItem(key)
  if (json)
    return JSON.parse(json)

  return null
}

export function removeLocal(key: string) {
  window.localStorage.removeItem(key)
}

export function clearLocal() {
  window.localStorage.clear()
}

export function setSession(key: string, value: unknown) {
  const json = JSON.stringify(value)
  sessionStorage.setItem(key, json)
}

export function getSession<T>(key: string) {
  const json = sessionStorage.getItem(key)
  const data: T | null = null
  if (json)
    return JSON.parse(json)

  return data
}

export function removeSession(key: string) {
  window.sessionStorage.removeItem(key)
}

export function clearSession() {
  window.sessionStorage.clear()
}
