import { isEmpty } from './typeof'

/**
 * 获取query参数
 * @param variable 变量名
 * @returns
 */
export function getQueryVariable(variable: string) {
  try {
    const query = !isEmpty(window.location.search)
      ? window.location.search.substring(1)
      : window.location.hash.split('?')[1]
    const vars = query.split('&')
    for (let i = 0; i < vars.length; i++) {
      const pair = vars[i].split('=')
      if (pair[0] === variable)
        return pair[1]
    }
    return false
  }
  catch (error) {
    return false
  }
}
