/**
 * 超过某整数数值取对应数值，不超过取整
 * @param num - 输入数值
 * @param max - 最大数值
 */
export function subMaxNumber(num: number, max: number) {
  return num < max ? Math.round(num) : max
}

/**
 * 取整
 * @param num - 输入数值
 */
export function mathRoundNumber(num: number) {
  return Math.round(num)
}

/**
 * 小数点后补0
 * @param e string -
 */
export function completionAmount(e: string) {
  if (!/\./.test(e)) {
    e += '.00'
  }
  else {
    const arrayNum = e.split('.')
    if (arrayNum[1].length < 2)
      e += '0'
  }
  return e
}

/**
 * 超过最大值取最大值，小于最小值取最小值
 * @param num - 需要进行范围限制的输入数字
 * @param greaterthan - 输入最大取值
 * @param lessthan - 输入最小取值
 */
export function greaterLessNumber(num: number, greaterthan: number, lessthan: number) {
  return num > greaterthan ? greaterthan : ((num < lessthan ? lessthan : num))
}

/**
 * 千分符，保留两位小数
 * @param num - 输入值
 */

export function millimeterFormat(num: number | string) {
  return (`${Number(num)}`).replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,')
}

/**
 * 千分位
 * @param data 数字
 * @returns 千分位的数字
 */
export const thousandthAmount = function (data: number | string, intgger = false, accuracy?: number): number {
  let number = (data || 0).toString()
  if (intgger)
    number = Math.abs(Number(number)).toString()
  const index = number.indexOf('.')
  let int = ''
  let decimal = ''
  let result = ''
  if (index !== -1) {
    int = number.split('.')[0]
    decimal = number.split('.')[1]
    while (int.length > 3) {
      result = `,${int.slice(-3)}${result}`
      int = int.slice(0, int.length - 3)
    }
    if (accuracy) {
      // console.log(decimal);
      const decimalNum = Number.parseFloat(`0.${decimal}`).toFixed(accuracy)
      decimal = decimalNum.split('.')[1]
    }
    if (int)
      result = `${int + result}.${decimal}`
  }
  else {
    const i = number.indexOf('-')
    if (i !== -1)
      number = number.slice(1)

    while (number.length > 3) {
      result = `,${number.slice(-3)}${result}`
      number = number.slice(0, number.length - 3)
    }
    if (number) {
      result = number + result
      if (i !== -1)
        result = `-${result}`
    }
  }
  return result as unknown as number
}
