import { List } from 'echarts'
import http from '../utils/request'

/**
 * 查询token合法
 * @params
 */
export function checkTokenApi() {
  return http.post('/user/api/user_center/mobile/v1/check_token', {})
}

/**
 * 消息配置信息
 * @params messageType [首页欢迎语 01]
 */
export function fetchMessageConfig(messageType: string) {
  return http.post('/config-center/api/message/mobile/v1/get_message_config', { messageType })
}

/**
 * 查询工具
 * @params
 */
export function fetchToolList() {
  return http.post('/config-center/api/tool/mobile/v1/get_tool_list', { })
}

/**
 * 查询推荐问题列表
 * @params
 */
export function fetchRecommendQuestionList() {
  return http.post('/config-center/api/question/mobile/v1/get_recommend_question_list')
}

/**
 * 获取协议列表
 * @returns
 */
export function fetchGetAgreementList() {
  return http.post('/config-center/api/commonconfig/mobile/v1/query_agreement_list')
}

/**
 * 获取配置信息
 * @returns
 */
export function fetchGetAppConfig() {
  return http.post('/config-center/api/commonconfig/mobile/v1/get_app_config')
}
