(() => {
  var __webpack_modules__ = {
    932: (module) => {
      function BrowserslistError(message) {
        this.name = "BrowserslistError";
        this.message = message;
        this.browserslist = true;
        if (Error.captureStackTrace) {
          Error.captureStackTrace(this, BrowserslistError);
        }
      }
      BrowserslistError.prototype = Error.prototype;
      module.exports = BrowserslistError;
    },
    80: (module, __unused_webpack_exports, __nccwpck_require__) => {
      var jsReleases = __nccwpck_require__(750);
      var agents = __nccwpck_require__(768).agents;
      var jsEOL = __nccwpck_require__(629);
      var path = __nccwpck_require__(17);
      var e2c = __nccwpck_require__(310);
      var BrowserslistError = __nccwpck_require__(932);
      var parse = __nccwpck_require__(911);
      var env = __nccwpck_require__(850);
      var YEAR = 365.259641 * 24 * 60 * 60 * 1e3;
      var ANDROID_EVERGREEN_FIRST = "37";
      var OP_MOB_BLINK_FIRST = 14;
      function isVersionsMatch(versionA, versionB) {
        return (versionA + ".").indexOf(versionB + ".") === 0;
      }
      function isEolReleased(name) {
        var version = name.slice(1);
        return browserslist.nodeVersions.some(function (i) {
          return isVersionsMatch(i, version);
        });
      }
      function normalize(versions) {
        return versions.filter(function (version) {
          return typeof version === "string";
        });
      }
      function normalizeElectron(version) {
        var versionToUse = version;
        if (version.split(".").length === 3) {
          versionToUse = version.split(".").slice(0, -1).join(".");
        }
        return versionToUse;
      }
      function nameMapper(name) {
        return function mapName(version) {
          return name + " " + version;
        };
      }
      function getMajor(version) {
        return parseInt(version.split(".")[0]);
      }
      function getMajorVersions(released, number) {
        if (released.length === 0) return [];
        var majorVersions = uniq(released.map(getMajor));
        var minimum = majorVersions[majorVersions.length - number];
        if (!minimum) {
          return released;
        }
        var selected = [];
        for (var i = released.length - 1; i >= 0; i--) {
          if (minimum > getMajor(released[i])) break;
          selected.unshift(released[i]);
        }
        return selected;
      }
      function uniq(array) {
        var filtered = [];
        for (var i = 0; i < array.length; i++) {
          if (filtered.indexOf(array[i]) === -1) filtered.push(array[i]);
        }
        return filtered;
      }
      function fillUsage(result, name, data) {
        for (var i in data) {
          result[name + " " + i] = data[i];
        }
      }
      function generateFilter(sign, version) {
        version = parseFloat(version);
        if (sign === ">") {
          return function (v) {
            return parseFloat(v) > version;
          };
        } else if (sign === ">=") {
          return function (v) {
            return parseFloat(v) >= version;
          };
        } else if (sign === "<") {
          return function (v) {
            return parseFloat(v) < version;
          };
        } else {
          return function (v) {
            return parseFloat(v) <= version;
          };
        }
      }
      function generateSemverFilter(sign, version) {
        version = version.split(".").map(parseSimpleInt);
        version[1] = version[1] || 0;
        version[2] = version[2] || 0;
        if (sign === ">") {
          return function (v) {
            v = v.split(".").map(parseSimpleInt);
            return compareSemver(v, version) > 0;
          };
        } else if (sign === ">=") {
          return function (v) {
            v = v.split(".").map(parseSimpleInt);
            return compareSemver(v, version) >= 0;
          };
        } else if (sign === "<") {
          return function (v) {
            v = v.split(".").map(parseSimpleInt);
            return compareSemver(version, v) > 0;
          };
        } else {
          return function (v) {
            v = v.split(".").map(parseSimpleInt);
            return compareSemver(version, v) >= 0;
          };
        }
      }
      function parseSimpleInt(x) {
        return parseInt(x);
      }
      function compare(a, b) {
        if (a < b) return -1;
        if (a > b) return +1;
        return 0;
      }
      function compareSemver(a, b) {
        return (
          compare(parseInt(a[0]), parseInt(b[0])) ||
          compare(parseInt(a[1] || "0"), parseInt(b[1] || "0")) ||
          compare(parseInt(a[2] || "0"), parseInt(b[2] || "0"))
        );
      }
      function semverFilterLoose(operator, range) {
        range = range.split(".").map(parseSimpleInt);
        if (typeof range[1] === "undefined") {
          range[1] = "x";
        }
        switch (operator) {
          case "<=":
            return function (version) {
              version = version.split(".").map(parseSimpleInt);
              return compareSemverLoose(version, range) <= 0;
            };
          case ">=":
          default:
            return function (version) {
              version = version.split(".").map(parseSimpleInt);
              return compareSemverLoose(version, range) >= 0;
            };
        }
      }
      function compareSemverLoose(version, range) {
        if (version[0] !== range[0]) {
          return version[0] < range[0] ? -1 : +1;
        }
        if (range[1] === "x") {
          return 0;
        }
        if (version[1] !== range[1]) {
          return version[1] < range[1] ? -1 : +1;
        }
        return 0;
      }
      function resolveVersion(data, version) {
        if (data.versions.indexOf(version) !== -1) {
          return version;
        } else if (browserslist.versionAliases[data.name][version]) {
          return browserslist.versionAliases[data.name][version];
        } else {
          return false;
        }
      }
      function normalizeVersion(data, version) {
        var resolved = resolveVersion(data, version);
        if (resolved) {
          return resolved;
        } else if (data.versions.length === 1) {
          return data.versions[0];
        } else {
          return false;
        }
      }
      function filterByYear(since, context) {
        since = since / 1e3;
        return Object.keys(agents).reduce(function (selected, name) {
          var data = byName(name, context);
          if (!data) return selected;
          var versions = Object.keys(data.releaseDate).filter(function (v) {
            var date = data.releaseDate[v];
            return date !== null && date >= since;
          });
          return selected.concat(versions.map(nameMapper(data.name)));
        }, []);
      }
      function cloneData(data) {
        return {
          name: data.name,
          versions: data.versions,
          released: data.released,
          releaseDate: data.releaseDate,
        };
      }
      function byName(name, context) {
        name = name.toLowerCase();
        name = browserslist.aliases[name] || name;
        if (context.mobileToDesktop && browserslist.desktopNames[name]) {
          var desktop = browserslist.data[browserslist.desktopNames[name]];
          if (name === "android") {
            return normalizeAndroidData(
              cloneData(browserslist.data[name]),
              desktop,
            );
          } else {
            var cloned = cloneData(desktop);
            cloned.name = name;
            return cloned;
          }
        }
        return browserslist.data[name];
      }
      function normalizeAndroidVersions(androidVersions, chromeVersions) {
        var iFirstEvergreen = chromeVersions.indexOf(ANDROID_EVERGREEN_FIRST);
        return androidVersions
          .filter(function (version) {
            return /^(?:[2-4]\.|[34]$)/.test(version);
          })
          .concat(chromeVersions.slice(iFirstEvergreen));
      }
      function copyObject(obj) {
        var copy = {};
        for (var key in obj) {
          copy[key] = obj[key];
        }
        return copy;
      }
      function normalizeAndroidData(android, chrome) {
        android.released = normalizeAndroidVersions(
          android.released,
          chrome.released,
        );
        android.versions = normalizeAndroidVersions(
          android.versions,
          chrome.versions,
        );
        android.releaseDate = copyObject(android.releaseDate);
        android.released.forEach(function (v) {
          if (android.releaseDate[v] === undefined) {
            android.releaseDate[v] = chrome.releaseDate[v];
          }
        });
        return android;
      }
      function checkName(name, context) {
        var data = byName(name, context);
        if (!data) throw new BrowserslistError("Unknown browser " + name);
        return data;
      }
      function unknownQuery(query) {
        return new BrowserslistError(
          "Unknown browser query `" +
            query +
            "`. " +
            "Maybe you are using old Browserslist or made typo in query.",
        );
      }
      function filterJumps(list, name, nVersions, context) {
        var jump = 1;
        switch (name) {
          case "android":
            if (context.mobileToDesktop) return list;
            var released = browserslist.data.chrome.released;
            jump = released.length - released.indexOf(ANDROID_EVERGREEN_FIRST);
            break;
          case "op_mob":
            var latest = browserslist.data.op_mob.released.slice(-1)[0];
            jump = getMajor(latest) - OP_MOB_BLINK_FIRST + 1;
            break;
          default:
            return list;
        }
        if (nVersions <= jump) {
          return list.slice(-1);
        }
        return list.slice(jump - 1 - nVersions);
      }
      function isSupported(flags, withPartial) {
        return (
          typeof flags === "string" &&
          (flags.indexOf("y") >= 0 || (withPartial && flags.indexOf("a") >= 0))
        );
      }
      function resolve(queries, context) {
        return parse(QUERIES, queries).reduce(function (result, node, index) {
          if (node.not && index === 0) {
            throw new BrowserslistError(
              "Write any browsers query (for instance, `defaults`) " +
                "before `" +
                node.query +
                "`",
            );
          }
          var type = QUERIES[node.type];
          var array = type.select
            .call(browserslist, context, node)
            .map(function (j) {
              var parts = j.split(" ");
              if (parts[1] === "0") {
                return parts[0] + " " + byName(parts[0], context).versions[0];
              } else {
                return j;
              }
            });
          if (node.compose === "and") {
            if (node.not) {
              return result.filter(function (j) {
                return array.indexOf(j) === -1;
              });
            } else {
              return result.filter(function (j) {
                return array.indexOf(j) !== -1;
              });
            }
          } else {
            if (node.not) {
              var filter = {};
              array.forEach(function (j) {
                filter[j] = true;
              });
              return result.filter(function (j) {
                return !filter[j];
              });
            }
            return result.concat(array);
          }
        }, []);
      }
      function prepareOpts(opts) {
        if (typeof opts === "undefined") opts = {};
        if (typeof opts.path === "undefined") {
          opts.path = path.resolve ? path.resolve(".") : ".";
        }
        return opts;
      }
      function prepareQueries(queries, opts) {
        if (typeof queries === "undefined" || queries === null) {
          var config = browserslist.loadConfig(opts);
          if (config) {
            queries = config;
          } else {
            queries = browserslist.defaults;
          }
        }
        return queries;
      }
      function checkQueries(queries) {
        if (!(typeof queries === "string" || Array.isArray(queries))) {
          throw new BrowserslistError(
            "Browser queries must be an array or string. Got " +
              typeof queries +
              ".",
          );
        }
      }
      var cache = {};
      function browserslist(queries, opts) {
        opts = prepareOpts(opts);
        queries = prepareQueries(queries, opts);
        checkQueries(queries);
        var context = {
          ignoreUnknownVersions: opts.ignoreUnknownVersions,
          dangerousExtend: opts.dangerousExtend,
          mobileToDesktop: opts.mobileToDesktop,
          path: opts.path,
          env: opts.env,
        };
        env.oldDataWarning(browserslist.data);
        var stats = env.getStat(opts, browserslist.data);
        if (stats) {
          context.customUsage = {};
          for (var browser in stats) {
            fillUsage(context.customUsage, browser, stats[browser]);
          }
        }
        var cacheKey = JSON.stringify([queries, context]);
        if (cache[cacheKey]) return cache[cacheKey];
        var result = uniq(resolve(queries, context)).sort(
          function (name1, name2) {
            name1 = name1.split(" ");
            name2 = name2.split(" ");
            if (name1[0] === name2[0]) {
              var version1 = name1[1].split("-")[0];
              var version2 = name2[1].split("-")[0];
              return compareSemver(version2.split("."), version1.split("."));
            } else {
              return compare(name1[0], name2[0]);
            }
          },
        );
        if (!env.env.BROWSERSLIST_DISABLE_CACHE) {
          cache[cacheKey] = result;
        }
        return result;
      }
      browserslist.parse = function (queries, opts) {
        opts = prepareOpts(opts);
        queries = prepareQueries(queries, opts);
        checkQueries(queries);
        return parse(QUERIES, queries);
      };
      browserslist.cache = {};
      browserslist.data = {};
      browserslist.usage = { global: {}, custom: null };
      browserslist.defaults = [
        "> 0.5%",
        "last 2 versions",
        "Firefox ESR",
        "not dead",
      ];
      browserslist.aliases = {
        fx: "firefox",
        ff: "firefox",
        ios: "ios_saf",
        explorer: "ie",
        blackberry: "bb",
        explorermobile: "ie_mob",
        operamini: "op_mini",
        operamobile: "op_mob",
        chromeandroid: "and_chr",
        firefoxandroid: "and_ff",
        ucandroid: "and_uc",
        qqandroid: "and_qq",
      };
      browserslist.desktopNames = {
        and_chr: "chrome",
        and_ff: "firefox",
        ie_mob: "ie",
        android: "chrome",
      };
      browserslist.versionAliases = {};
      browserslist.clearCaches = env.clearCaches;
      browserslist.parseConfig = env.parseConfig;
      browserslist.readConfig = env.readConfig;
      browserslist.findConfig = env.findConfig;
      browserslist.loadConfig = env.loadConfig;
      browserslist.coverage = function (browsers, stats) {
        var data;
        if (typeof stats === "undefined") {
          data = browserslist.usage.global;
        } else if (stats === "my stats") {
          var opts = {};
          opts.path = path.resolve ? path.resolve(".") : ".";
          var customStats = env.getStat(opts);
          if (!customStats) {
            throw new BrowserslistError(
              "Custom usage statistics was not provided",
            );
          }
          data = {};
          for (var browser in customStats) {
            fillUsage(data, browser, customStats[browser]);
          }
        } else if (typeof stats === "string") {
          if (stats.length > 2) {
            stats = stats.toLowerCase();
          } else {
            stats = stats.toUpperCase();
          }
          env.loadCountry(browserslist.usage, stats, browserslist.data);
          data = browserslist.usage[stats];
        } else {
          if ("dataByBrowser" in stats) {
            stats = stats.dataByBrowser;
          }
          data = {};
          for (var name in stats) {
            for (var version in stats[name]) {
              data[name + " " + version] = stats[name][version];
            }
          }
        }
        return browsers.reduce(function (all, i) {
          var usage = data[i];
          if (usage === undefined) {
            usage = data[i.replace(/ \S+$/, " 0")];
          }
          return all + (usage || 0);
        }, 0);
      };
      function nodeQuery(context, node) {
        var matched = browserslist.nodeVersions.filter(function (i) {
          return isVersionsMatch(i, node.version);
        });
        if (matched.length === 0) {
          if (context.ignoreUnknownVersions) {
            return [];
          } else {
            throw new BrowserslistError(
              "Unknown version " + node.version + " of Node.js",
            );
          }
        }
        return ["node " + matched[matched.length - 1]];
      }
      function sinceQuery(context, node) {
        var year = parseInt(node.year);
        var month = parseInt(node.month || "01") - 1;
        var day = parseInt(node.day || "01");
        return filterByYear(Date.UTC(year, month, day, 0, 0, 0), context);
      }
      function coverQuery(context, node) {
        var coverage = parseFloat(node.coverage);
        var usage = browserslist.usage.global;
        if (node.place) {
          if (node.place.match(/^my\s+stats$/i)) {
            if (!context.customUsage) {
              throw new BrowserslistError(
                "Custom usage statistics was not provided",
              );
            }
            usage = context.customUsage;
          } else {
            var place;
            if (node.place.length === 2) {
              place = node.place.toUpperCase();
            } else {
              place = node.place.toLowerCase();
            }
            env.loadCountry(browserslist.usage, place, browserslist.data);
            usage = browserslist.usage[place];
          }
        }
        var versions = Object.keys(usage).sort(function (a, b) {
          return usage[b] - usage[a];
        });
        var coveraged = 0;
        var result = [];
        var version;
        for (var i = 0; i < versions.length; i++) {
          version = versions[i];
          if (usage[version] === 0) break;
          coveraged += usage[version];
          result.push(version);
          if (coveraged >= coverage) break;
        }
        return result;
      }
      var QUERIES = {
        last_major_versions: {
          matches: ["versions"],
          regexp: /^last\s+(\d+)\s+major\s+versions?$/i,
          select: function (context, node) {
            return Object.keys(agents).reduce(function (selected, name) {
              var data = byName(name, context);
              if (!data) return selected;
              var list = getMajorVersions(data.released, node.versions);
              list = list.map(nameMapper(data.name));
              list = filterJumps(list, data.name, node.versions, context);
              return selected.concat(list);
            }, []);
          },
        },
        last_versions: {
          matches: ["versions"],
          regexp: /^last\s+(\d+)\s+versions?$/i,
          select: function (context, node) {
            return Object.keys(agents).reduce(function (selected, name) {
              var data = byName(name, context);
              if (!data) return selected;
              var list = data.released.slice(-node.versions);
              list = list.map(nameMapper(data.name));
              list = filterJumps(list, data.name, node.versions, context);
              return selected.concat(list);
            }, []);
          },
        },
        last_electron_major_versions: {
          matches: ["versions"],
          regexp: /^last\s+(\d+)\s+electron\s+major\s+versions?$/i,
          select: function (context, node) {
            var validVersions = getMajorVersions(
              Object.keys(e2c),
              node.versions,
            );
            return validVersions.map(function (i) {
              return "chrome " + e2c[i];
            });
          },
        },
        last_node_major_versions: {
          matches: ["versions"],
          regexp: /^last\s+(\d+)\s+node\s+major\s+versions?$/i,
          select: function (context, node) {
            return getMajorVersions(
              browserslist.nodeVersions,
              node.versions,
            ).map(function (version) {
              return "node " + version;
            });
          },
        },
        last_browser_major_versions: {
          matches: ["versions", "browser"],
          regexp: /^last\s+(\d+)\s+(\w+)\s+major\s+versions?$/i,
          select: function (context, node) {
            var data = checkName(node.browser, context);
            var validVersions = getMajorVersions(data.released, node.versions);
            var list = validVersions.map(nameMapper(data.name));
            list = filterJumps(list, data.name, node.versions, context);
            return list;
          },
        },
        last_electron_versions: {
          matches: ["versions"],
          regexp: /^last\s+(\d+)\s+electron\s+versions?$/i,
          select: function (context, node) {
            return Object.keys(e2c)
              .slice(-node.versions)
              .map(function (i) {
                return "chrome " + e2c[i];
              });
          },
        },
        last_node_versions: {
          matches: ["versions"],
          regexp: /^last\s+(\d+)\s+node\s+versions?$/i,
          select: function (context, node) {
            return browserslist.nodeVersions
              .slice(-node.versions)
              .map(function (version) {
                return "node " + version;
              });
          },
        },
        last_browser_versions: {
          matches: ["versions", "browser"],
          regexp: /^last\s+(\d+)\s+(\w+)\s+versions?$/i,
          select: function (context, node) {
            var data = checkName(node.browser, context);
            var list = data.released
              .slice(-node.versions)
              .map(nameMapper(data.name));
            list = filterJumps(list, data.name, node.versions, context);
            return list;
          },
        },
        unreleased_versions: {
          matches: [],
          regexp: /^unreleased\s+versions$/i,
          select: function (context) {
            return Object.keys(agents).reduce(function (selected, name) {
              var data = byName(name, context);
              if (!data) return selected;
              var list = data.versions.filter(function (v) {
                return data.released.indexOf(v) === -1;
              });
              list = list.map(nameMapper(data.name));
              return selected.concat(list);
            }, []);
          },
        },
        unreleased_electron_versions: {
          matches: [],
          regexp: /^unreleased\s+electron\s+versions?$/i,
          select: function () {
            return [];
          },
        },
        unreleased_browser_versions: {
          matches: ["browser"],
          regexp: /^unreleased\s+(\w+)\s+versions?$/i,
          select: function (context, node) {
            var data = checkName(node.browser, context);
            return data.versions
              .filter(function (v) {
                return data.released.indexOf(v) === -1;
              })
              .map(nameMapper(data.name));
          },
        },
        last_years: {
          matches: ["years"],
          regexp: /^last\s+(\d*.?\d+)\s+years?$/i,
          select: function (context, node) {
            return filterByYear(Date.now() - YEAR * node.years, context);
          },
        },
        since_y: {
          matches: ["year"],
          regexp: /^since (\d+)$/i,
          select: sinceQuery,
        },
        since_y_m: {
          matches: ["year", "month"],
          regexp: /^since (\d+)-(\d+)$/i,
          select: sinceQuery,
        },
        since_y_m_d: {
          matches: ["year", "month", "day"],
          regexp: /^since (\d+)-(\d+)-(\d+)$/i,
          select: sinceQuery,
        },
        popularity: {
          matches: ["sign", "popularity"],
          regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%$/,
          select: function (context, node) {
            var popularity = parseFloat(node.popularity);
            var usage = browserslist.usage.global;
            return Object.keys(usage).reduce(function (result, version) {
              if (node.sign === ">") {
                if (usage[version] > popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<") {
                if (usage[version] < popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<=") {
                if (usage[version] <= popularity) {
                  result.push(version);
                }
              } else if (usage[version] >= popularity) {
                result.push(version);
              }
              return result;
            }, []);
          },
        },
        popularity_in_my_stats: {
          matches: ["sign", "popularity"],
          regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+my\s+stats$/,
          select: function (context, node) {
            var popularity = parseFloat(node.popularity);
            if (!context.customUsage) {
              throw new BrowserslistError(
                "Custom usage statistics was not provided",
              );
            }
            var usage = context.customUsage;
            return Object.keys(usage).reduce(function (result, version) {
              var percentage = usage[version];
              if (percentage == null) {
                return result;
              }
              if (node.sign === ">") {
                if (percentage > popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<") {
                if (percentage < popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<=") {
                if (percentage <= popularity) {
                  result.push(version);
                }
              } else if (percentage >= popularity) {
                result.push(version);
              }
              return result;
            }, []);
          },
        },
        popularity_in_config_stats: {
          matches: ["sign", "popularity", "config"],
          regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+(\S+)\s+stats$/,
          select: function (context, node) {
            var popularity = parseFloat(node.popularity);
            var stats = env.loadStat(context, node.config, browserslist.data);
            if (stats) {
              context.customUsage = {};
              for (var browser in stats) {
                fillUsage(context.customUsage, browser, stats[browser]);
              }
            }
            if (!context.customUsage) {
              throw new BrowserslistError(
                "Custom usage statistics was not provided",
              );
            }
            var usage = context.customUsage;
            return Object.keys(usage).reduce(function (result, version) {
              var percentage = usage[version];
              if (percentage == null) {
                return result;
              }
              if (node.sign === ">") {
                if (percentage > popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<") {
                if (percentage < popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<=") {
                if (percentage <= popularity) {
                  result.push(version);
                }
              } else if (percentage >= popularity) {
                result.push(version);
              }
              return result;
            }, []);
          },
        },
        popularity_in_place: {
          matches: ["sign", "popularity", "place"],
          regexp: /^(>=?|<=?)\s*(\d+|\d+\.\d+|\.\d+)%\s+in\s+((alt-)?\w\w)$/,
          select: function (context, node) {
            var popularity = parseFloat(node.popularity);
            var place = node.place;
            if (place.length === 2) {
              place = place.toUpperCase();
            } else {
              place = place.toLowerCase();
            }
            env.loadCountry(browserslist.usage, place, browserslist.data);
            var usage = browserslist.usage[place];
            return Object.keys(usage).reduce(function (result, version) {
              var percentage = usage[version];
              if (percentage == null) {
                return result;
              }
              if (node.sign === ">") {
                if (percentage > popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<") {
                if (percentage < popularity) {
                  result.push(version);
                }
              } else if (node.sign === "<=") {
                if (percentage <= popularity) {
                  result.push(version);
                }
              } else if (percentage >= popularity) {
                result.push(version);
              }
              return result;
            }, []);
          },
        },
        cover: {
          matches: ["coverage"],
          regexp: /^cover\s+(\d+|\d+\.\d+|\.\d+)%$/i,
          select: coverQuery,
        },
        cover_in: {
          matches: ["coverage", "place"],
          regexp:
            /^cover\s+(\d+|\d+\.\d+|\.\d+)%\s+in\s+(my\s+stats|(alt-)?\w\w)$/i,
          select: coverQuery,
        },
        supports: {
          matches: ["supportType", "feature"],
          regexp: /^(?:(fully|partially)\s+)?supports\s+([\w-]+)$/,
          select: function (context, node) {
            env.loadFeature(browserslist.cache, node.feature);
            var withPartial = node.supportType !== "fully";
            var features = browserslist.cache[node.feature];
            var result = [];
            for (var name in features) {
              var data = byName(name, context);
              var iMax = data.released.length - 1;
              while (iMax >= 0) {
                if (data.released[iMax] in features[name]) break;
                iMax--;
              }
              var checkDesktop =
                context.mobileToDesktop &&
                name in browserslist.desktopNames &&
                isSupported(features[name][data.released[iMax]], withPartial);
              data.versions.forEach(function (version) {
                var flags = features[name][version];
                if (flags === undefined && checkDesktop) {
                  flags = features[browserslist.desktopNames[name]][version];
                }
                if (isSupported(flags, withPartial)) {
                  result.push(name + " " + version);
                }
              });
            }
            return result;
          },
        },
        electron_range: {
          matches: ["from", "to"],
          regexp: /^electron\s+([\d.]+)\s*-\s*([\d.]+)$/i,
          select: function (context, node) {
            var fromToUse = normalizeElectron(node.from);
            var toToUse = normalizeElectron(node.to);
            var from = parseFloat(node.from);
            var to = parseFloat(node.to);
            if (!e2c[fromToUse]) {
              throw new BrowserslistError(
                "Unknown version " + from + " of electron",
              );
            }
            if (!e2c[toToUse]) {
              throw new BrowserslistError(
                "Unknown version " + to + " of electron",
              );
            }
            return Object.keys(e2c)
              .filter(function (i) {
                var parsed = parseFloat(i);
                return parsed >= from && parsed <= to;
              })
              .map(function (i) {
                return "chrome " + e2c[i];
              });
          },
        },
        node_range: {
          matches: ["from", "to"],
          regexp: /^node\s+([\d.]+)\s*-\s*([\d.]+)$/i,
          select: function (context, node) {
            return browserslist.nodeVersions
              .filter(semverFilterLoose(">=", node.from))
              .filter(semverFilterLoose("<=", node.to))
              .map(function (v) {
                return "node " + v;
              });
          },
        },
        browser_range: {
          matches: ["browser", "from", "to"],
          regexp: /^(\w+)\s+([\d.]+)\s*-\s*([\d.]+)$/i,
          select: function (context, node) {
            var data = checkName(node.browser, context);
            var from = parseFloat(
              normalizeVersion(data, node.from) || node.from,
            );
            var to = parseFloat(normalizeVersion(data, node.to) || node.to);
            function filter(v) {
              var parsed = parseFloat(v);
              return parsed >= from && parsed <= to;
            }
            return data.released.filter(filter).map(nameMapper(data.name));
          },
        },
        electron_ray: {
          matches: ["sign", "version"],
          regexp: /^electron\s*(>=?|<=?)\s*([\d.]+)$/i,
          select: function (context, node) {
            var versionToUse = normalizeElectron(node.version);
            return Object.keys(e2c)
              .filter(generateFilter(node.sign, versionToUse))
              .map(function (i) {
                return "chrome " + e2c[i];
              });
          },
        },
        node_ray: {
          matches: ["sign", "version"],
          regexp: /^node\s*(>=?|<=?)\s*([\d.]+)$/i,
          select: function (context, node) {
            return browserslist.nodeVersions
              .filter(generateSemverFilter(node.sign, node.version))
              .map(function (v) {
                return "node " + v;
              });
          },
        },
        browser_ray: {
          matches: ["browser", "sign", "version"],
          regexp: /^(\w+)\s*(>=?|<=?)\s*([\d.]+)$/,
          select: function (context, node) {
            var version = node.version;
            var data = checkName(node.browser, context);
            var alias = browserslist.versionAliases[data.name][version];
            if (alias) version = alias;
            return data.released
              .filter(generateFilter(node.sign, version))
              .map(function (v) {
                return data.name + " " + v;
              });
          },
        },
        firefox_esr: {
          matches: [],
          regexp: /^(firefox|ff|fx)\s+esr$/i,
          select: function () {
            return ["firefox 115", "firefox 128"];
          },
        },
        opera_mini_all: {
          matches: [],
          regexp: /(operamini|op_mini)\s+all/i,
          select: function () {
            return ["op_mini all"];
          },
        },
        electron_version: {
          matches: ["version"],
          regexp: /^electron\s+([\d.]+)$/i,
          select: function (context, node) {
            var versionToUse = normalizeElectron(node.version);
            var chrome = e2c[versionToUse];
            if (!chrome) {
              throw new BrowserslistError(
                "Unknown version " + node.version + " of electron",
              );
            }
            return ["chrome " + chrome];
          },
        },
        node_major_version: {
          matches: ["version"],
          regexp: /^node\s+(\d+)$/i,
          select: nodeQuery,
        },
        node_minor_version: {
          matches: ["version"],
          regexp: /^node\s+(\d+\.\d+)$/i,
          select: nodeQuery,
        },
        node_patch_version: {
          matches: ["version"],
          regexp: /^node\s+(\d+\.\d+\.\d+)$/i,
          select: nodeQuery,
        },
        current_node: {
          matches: [],
          regexp: /^current\s+node$/i,
          select: function (context) {
            return [env.currentNode(resolve, context)];
          },
        },
        maintained_node: {
          matches: [],
          regexp: /^maintained\s+node\s+versions$/i,
          select: function (context) {
            var now = Date.now();
            var queries = Object.keys(jsEOL)
              .filter(function (key) {
                return (
                  now < Date.parse(jsEOL[key].end) &&
                  now > Date.parse(jsEOL[key].start) &&
                  isEolReleased(key)
                );
              })
              .map(function (key) {
                return "node " + key.slice(1);
              });
            return resolve(queries, context);
          },
        },
        phantomjs_1_9: {
          matches: [],
          regexp: /^phantomjs\s+1.9$/i,
          select: function () {
            return ["safari 5"];
          },
        },
        phantomjs_2_1: {
          matches: [],
          regexp: /^phantomjs\s+2.1$/i,
          select: function () {
            return ["safari 6"];
          },
        },
        browser_version: {
          matches: ["browser", "version"],
          regexp: /^(\w+)\s+(tp|[\d.]+)$/i,
          select: function (context, node) {
            var version = node.version;
            if (/^tp$/i.test(version)) version = "TP";
            var data = checkName(node.browser, context);
            var alias = normalizeVersion(data, version);
            if (alias) {
              version = alias;
            } else {
              if (version.indexOf(".") === -1) {
                alias = version + ".0";
              } else {
                alias = version.replace(/\.0$/, "");
              }
              alias = normalizeVersion(data, alias);
              if (alias) {
                version = alias;
              } else if (context.ignoreUnknownVersions) {
                return [];
              } else {
                throw new BrowserslistError(
                  "Unknown version " + version + " of " + node.browser,
                );
              }
            }
            return [data.name + " " + version];
          },
        },
        browserslist_config: {
          matches: [],
          regexp: /^browserslist config$/i,
          select: function (context) {
            return browserslist(undefined, context);
          },
        },
        extends: {
          matches: ["config"],
          regexp: /^extends (.+)$/i,
          select: function (context, node) {
            return resolve(env.loadQueries(context, node.config), context);
          },
        },
        defaults: {
          matches: [],
          regexp: /^defaults$/i,
          select: function (context) {
            return resolve(browserslist.defaults, context);
          },
        },
        dead: {
          matches: [],
          regexp: /^dead$/i,
          select: function (context) {
            var dead = [
              "Baidu >= 0",
              "ie <= 11",
              "ie_mob <= 11",
              "bb <= 10",
              "op_mob <= 12.1",
              "samsung 4",
            ];
            return resolve(dead, context);
          },
        },
        unknown: {
          matches: [],
          regexp: /^(\w+)$/i,
          select: function (context, node) {
            if (byName(node.query, context)) {
              throw new BrowserslistError(
                "Specify versions in Browserslist query for browser " +
                  node.query,
              );
            } else {
              throw unknownQuery(node.query);
            }
          },
        },
      };
      (function () {
        for (var name in agents) {
          var browser = agents[name];
          browserslist.data[name] = {
            name,
            versions: normalize(agents[name].versions),
            released: normalize(agents[name].versions.slice(0, -3)),
            releaseDate: agents[name].release_date,
          };
          fillUsage(browserslist.usage.global, name, browser.usage_global);
          browserslist.versionAliases[name] = {};
          for (var i = 0; i < browser.versions.length; i++) {
            var full = browser.versions[i];
            if (!full) continue;
            if (full.indexOf("-") !== -1) {
              var interval = full.split("-");
              for (var j = 0; j < interval.length; j++) {
                browserslist.versionAliases[name][interval[j]] = full;
              }
            }
          }
        }
        browserslist.nodeVersions = jsReleases.map(function (release) {
          return release.version;
        });
      })();
      module.exports = browserslist;
    },
    850: (module, __unused_webpack_exports, __nccwpck_require__) => {
      var feature = __nccwpck_require__(711)["default"];
      var region = __nccwpck_require__(225)["default"];
      var path = __nccwpck_require__(17);
      var fs = __nccwpck_require__(147);
      var BrowserslistError = __nccwpck_require__(932);
      var IS_SECTION = /^\s*\[(.+)]\s*$/;
      var CONFIG_PATTERN = /^browserslist-config-/;
      var SCOPED_CONFIG__PATTERN =
        /@[^/]+(?:\/[^/]+)?\/browserslist-config(?:-|$|\/)/;
      var TIME_TO_UPDATE_CANIUSE = 6 * 30 * 24 * 60 * 60 * 1e3;
      var FORMAT =
        "Browserslist config should be a string or an array " +
        "of strings with browser queries";
      var dataTimeChecked = false;
      var filenessCache = {};
      var configCache = {};
      function checkExtend(name) {
        var use = " Use `dangerousExtend` option to disable.";
        if (!CONFIG_PATTERN.test(name) && !SCOPED_CONFIG__PATTERN.test(name)) {
          throw new BrowserslistError(
            "Browserslist config needs `browserslist-config-` prefix. " + use,
          );
        }
        if (name.replace(/^@[^/]+\//, "").indexOf(".") !== -1) {
          throw new BrowserslistError(
            "`.` not allowed in Browserslist config name. " + use,
          );
        }
        if (name.indexOf("node_modules") !== -1) {
          throw new BrowserslistError(
            "`node_modules` not allowed in Browserslist config." + use,
          );
        }
      }
      function isFile(file) {
        if (file in filenessCache) {
          return filenessCache[file];
        }
        var result = fs.existsSync(file) && fs.statSync(file).isFile();
        if (!process.env.BROWSERSLIST_DISABLE_CACHE) {
          filenessCache[file] = result;
        }
        return result;
      }
      function eachParent(file, callback) {
        var dir = isFile(file) ? path.dirname(file) : file;
        var loc = path.resolve(dir);
        do {
          if (!pathInRoot(loc)) break;
          var result = callback(loc);
          if (typeof result !== "undefined") return result;
        } while (loc !== (loc = path.dirname(loc)));
        return undefined;
      }
      function pathInRoot(p) {
        if (!process.env.BROWSERSLIST_ROOT_PATH) return true;
        var rootPath = path.resolve(process.env.BROWSERSLIST_ROOT_PATH);
        if (path.relative(rootPath, p).substring(0, 2) === "..") {
          return false;
        }
        return true;
      }
      function check(section) {
        if (Array.isArray(section)) {
          for (var i = 0; i < section.length; i++) {
            if (typeof section[i] !== "string") {
              throw new BrowserslistError(FORMAT);
            }
          }
        } else if (typeof section !== "string") {
          throw new BrowserslistError(FORMAT);
        }
      }
      function pickEnv(config, opts) {
        if (typeof config !== "object") return config;
        var name;
        if (typeof opts.env === "string") {
          name = opts.env;
        } else if (process.env.BROWSERSLIST_ENV) {
          name = process.env.BROWSERSLIST_ENV;
        } else if (process.env.NODE_ENV) {
          name = process.env.NODE_ENV;
        } else {
          name = "production";
        }
        if (opts.throwOnMissing) {
          if (name && name !== "defaults" && !config[name]) {
            throw new BrowserslistError(
              "Missing config for Browserslist environment `" + name + "`",
            );
          }
        }
        return config[name] || config.defaults;
      }
      function parsePackage(file) {
        var config = JSON.parse(
          fs
            .readFileSync(file)
            .toString()
            .replace(/^\uFEFF/m, ""),
        );
        if (config.browserlist && !config.browserslist) {
          throw new BrowserslistError(
            "`browserlist` key instead of `browserslist` in " + file,
          );
        }
        var list = config.browserslist;
        if (Array.isArray(list) || typeof list === "string") {
          list = { defaults: list };
        }
        for (var i in list) {
          check(list[i]);
        }
        return list;
      }
      function latestReleaseTime(agents) {
        var latest = 0;
        for (var name in agents) {
          var dates = agents[name].releaseDate || {};
          for (var key in dates) {
            if (latest < dates[key]) {
              latest = dates[key];
            }
          }
        }
        return latest * 1e3;
      }
      function normalizeStats(data, stats) {
        if (!data) {
          data = {};
        }
        if (stats && "dataByBrowser" in stats) {
          stats = stats.dataByBrowser;
        }
        if (typeof stats !== "object") return undefined;
        var normalized = {};
        for (var i in stats) {
          var versions = Object.keys(stats[i]);
          if (
            versions.length === 1 &&
            data[i] &&
            data[i].versions.length === 1
          ) {
            var normal = data[i].versions[0];
            normalized[i] = {};
            normalized[i][normal] = stats[i][versions[0]];
          } else {
            normalized[i] = stats[i];
          }
        }
        return normalized;
      }
      function normalizeUsageData(usageData, data) {
        for (var browser in usageData) {
          var browserUsage = usageData[browser];
          if ("0" in browserUsage) {
            var versions = data[browser].versions;
            browserUsage[versions[versions.length - 1]] = browserUsage[0];
            delete browserUsage[0];
          }
        }
      }
      module.exports = {
        loadQueries: function loadQueries(ctx, name) {
          if (
            !ctx.dangerousExtend &&
            !process.env.BROWSERSLIST_DANGEROUS_EXTEND
          ) {
            checkExtend(name);
          }
          var queries = eval("require")(
            require.resolve(name, { paths: [".", ctx.path] }),
          );
          if (queries) {
            if (Array.isArray(queries)) {
              return queries;
            } else if (typeof queries === "object") {
              if (!queries.defaults) queries.defaults = [];
              return pickEnv(queries, ctx, name);
            }
          }
          throw new BrowserslistError(
            "`" +
              name +
              "` config exports not an array of queries" +
              " or an object of envs",
          );
        },
        loadStat: function loadStat(ctx, name, data) {
          if (
            !ctx.dangerousExtend &&
            !process.env.BROWSERSLIST_DANGEROUS_EXTEND
          ) {
            checkExtend(name);
          }
          var stats = eval("require")(
            require.resolve(path.join(name, "browserslist-stats.json"), {
              paths: ["."],
            }),
          );
          return normalizeStats(data, stats);
        },
        getStat: function getStat(opts, data) {
          var stats;
          if (opts.stats) {
            stats = opts.stats;
          } else if (process.env.BROWSERSLIST_STATS) {
            stats = process.env.BROWSERSLIST_STATS;
          } else if (opts.path && path.resolve && fs.existsSync) {
            stats = eachParent(opts.path, function (dir) {
              var file = path.join(dir, "browserslist-stats.json");
              return isFile(file) ? file : undefined;
            });
          }
          if (typeof stats === "string") {
            try {
              stats = JSON.parse(fs.readFileSync(stats));
            } catch (e) {
              throw new BrowserslistError("Can't read " + stats);
            }
          }
          return normalizeStats(data, stats);
        },
        loadConfig: function loadConfig(opts) {
          if (process.env.BROWSERSLIST) {
            return process.env.BROWSERSLIST;
          } else if (opts.config || process.env.BROWSERSLIST_CONFIG) {
            var file = opts.config || process.env.BROWSERSLIST_CONFIG;
            if (path.basename(file) === "package.json") {
              return pickEnv(parsePackage(file), opts);
            } else {
              return pickEnv(module.exports.readConfig(file), opts);
            }
          } else if (opts.path) {
            return pickEnv(module.exports.findConfig(opts.path), opts);
          } else {
            return undefined;
          }
        },
        loadCountry: function loadCountry(usage, country, data) {
          var code = country.replace(/[^\w-]/g, "");
          if (!usage[code]) {
            var compressed;
            try {
              compressed = require("caniuse-lite/data/regions/" + code + ".js");
            } catch (e) {
              throw new BrowserslistError(
                "Unknown region name `" + code + "`.",
              );
            }
            var usageData = region(compressed);
            normalizeUsageData(usageData, data);
            usage[country] = {};
            for (var i in usageData) {
              for (var j in usageData[i]) {
                usage[country][i + " " + j] = usageData[i][j];
              }
            }
          }
        },
        loadFeature: function loadFeature(features, name) {
          name = name.replace(/[^\w-]/g, "");
          if (features[name]) return;
          var compressed;
          try {
            compressed = require("caniuse-lite/data/features/" + name + ".js");
          } catch (e) {
            throw new BrowserslistError("Unknown feature name `" + name + "`.");
          }
          var stats = feature(compressed).stats;
          features[name] = {};
          for (var i in stats) {
            features[name][i] = {};
            for (var j in stats[i]) {
              features[name][i][j] = stats[i][j];
            }
          }
        },
        parseConfig: function parseConfig(string) {
          var result = { defaults: [] };
          var sections = ["defaults"];
          string
            .toString()
            .replace(/#[^\n]*/g, "")
            .split(/\n|,/)
            .map(function (line) {
              return line.trim();
            })
            .filter(function (line) {
              return line !== "";
            })
            .forEach(function (line) {
              if (IS_SECTION.test(line)) {
                sections = line.match(IS_SECTION)[1].trim().split(" ");
                sections.forEach(function (section) {
                  if (result[section]) {
                    throw new BrowserslistError(
                      "Duplicate section " +
                        section +
                        " in Browserslist config",
                    );
                  }
                  result[section] = [];
                });
              } else {
                sections.forEach(function (section) {
                  result[section].push(line);
                });
              }
            });
          return result;
        },
        readConfig: function readConfig(file) {
          if (!isFile(file)) {
            throw new BrowserslistError("Can't read " + file + " config");
          }
          return module.exports.parseConfig(fs.readFileSync(file));
        },
        findConfig: function findConfig(from) {
          from = path.resolve(from);
          var passed = [];
          var resolved = eachParent(from, function (dir) {
            if (dir in configCache) {
              return configCache[dir];
            }
            passed.push(dir);
            var config = path.join(dir, "browserslist");
            var pkg = path.join(dir, "package.json");
            var rc = path.join(dir, ".browserslistrc");
            var pkgBrowserslist;
            if (isFile(pkg)) {
              try {
                pkgBrowserslist = parsePackage(pkg);
              } catch (e) {
                if (e.name === "BrowserslistError") throw e;
                console.warn(
                  "[Browserslist] Could not parse " + pkg + ". Ignoring it.",
                );
              }
            }
            if (isFile(config) && pkgBrowserslist) {
              throw new BrowserslistError(
                dir +
                  " contains both browserslist and package.json with browsers",
              );
            } else if (isFile(rc) && pkgBrowserslist) {
              throw new BrowserslistError(
                dir +
                  " contains both .browserslistrc and package.json with browsers",
              );
            } else if (isFile(config) && isFile(rc)) {
              throw new BrowserslistError(
                dir + " contains both .browserslistrc and browserslist",
              );
            } else if (isFile(config)) {
              return module.exports.readConfig(config);
            } else if (isFile(rc)) {
              return module.exports.readConfig(rc);
            } else {
              return pkgBrowserslist;
            }
          });
          if (!process.env.BROWSERSLIST_DISABLE_CACHE) {
            passed.forEach(function (dir) {
              configCache[dir] = resolved;
            });
          }
          return resolved;
        },
        clearCaches: function clearCaches() {
          dataTimeChecked = false;
          filenessCache = {};
          configCache = {};
          this.cache = {};
        },
        oldDataWarning: function oldDataWarning(agentsObj) {
          if (dataTimeChecked) return;
          dataTimeChecked = true;
          if (process.env.BROWSERSLIST_IGNORE_OLD_DATA) return;
          var latest = latestReleaseTime(agentsObj);
          var halfYearAgo = Date.now() - TIME_TO_UPDATE_CANIUSE;
          if (latest !== 0 && latest < halfYearAgo) {
            console.warn(
              "Browserslist: caniuse-lite is outdated. Please run:\n" +
                "  npx update-browserslist-db@latest\n" +
                "  Why you should do it regularly: " +
                "https://github.com/browserslist/update-db#readme",
            );
          }
        },
        currentNode: function currentNode() {
          return "node " + process.versions.node;
        },
        env: process.env,
      };
    },
    911: (module) => {
      var AND_REGEXP = /^\s+and\s+(.*)/i;
      var OR_REGEXP = /^(?:,\s*|\s+or\s+)(.*)/i;
      function flatten(array) {
        if (!Array.isArray(array)) return [array];
        return array.reduce(function (a, b) {
          return a.concat(flatten(b));
        }, []);
      }
      function find(string, predicate) {
        for (var n = 1, max = string.length; n <= max; n++) {
          var parsed = string.substr(-n, n);
          if (predicate(parsed, n, max)) {
            return string.slice(0, -n);
          }
        }
        return "";
      }
      function matchQuery(all, query) {
        var node = { query };
        if (query.indexOf("not ") === 0) {
          node.not = true;
          query = query.slice(4);
        }
        for (var name in all) {
          var type = all[name];
          var match = query.match(type.regexp);
          if (match) {
            node.type = name;
            for (var i = 0; i < type.matches.length; i++) {
              node[type.matches[i]] = match[i + 1];
            }
            return node;
          }
        }
        node.type = "unknown";
        return node;
      }
      function matchBlock(all, string, qs) {
        var node;
        return find(string, function (parsed, n, max) {
          if (AND_REGEXP.test(parsed)) {
            node = matchQuery(all, parsed.match(AND_REGEXP)[1]);
            node.compose = "and";
            qs.unshift(node);
            return true;
          } else if (OR_REGEXP.test(parsed)) {
            node = matchQuery(all, parsed.match(OR_REGEXP)[1]);
            node.compose = "or";
            qs.unshift(node);
            return true;
          } else if (n === max) {
            node = matchQuery(all, parsed.trim());
            node.compose = "or";
            qs.unshift(node);
            return true;
          }
          return false;
        });
      }
      module.exports = function parse(all, queries) {
        if (!Array.isArray(queries)) queries = [queries];
        return flatten(
          queries.map(function (block) {
            var qs = [];
            do {
              block = matchBlock(all, block, qs);
            } while (block);
            return qs;
          }),
        );
      };
    },
    310: (module) => {
      module.exports = {
        "0.20": "39",
        0.21: "41",
        0.22: "41",
        0.23: "41",
        0.24: "41",
        0.25: "42",
        0.26: "42",
        0.27: "43",
        0.28: "43",
        0.29: "43",
        "0.30": "44",
        0.31: "45",
        0.32: "45",
        0.33: "45",
        0.34: "45",
        0.35: "45",
        0.36: "47",
        0.37: "49",
        "1.0": "49",
        1.1: "50",
        1.2: "51",
        1.3: "52",
        1.4: "53",
        1.5: "54",
        1.6: "56",
        1.7: "58",
        1.8: "59",
        "2.0": "61",
        2.1: "61",
        "3.0": "66",
        3.1: "66",
        "4.0": "69",
        4.1: "69",
        4.2: "69",
        "5.0": "73",
        "6.0": "76",
        6.1: "76",
        "7.0": "78",
        7.1: "78",
        7.2: "78",
        7.3: "78",
        "8.0": "80",
        8.1: "80",
        8.2: "80",
        8.3: "80",
        8.4: "80",
        8.5: "80",
        "9.0": "83",
        9.1: "83",
        9.2: "83",
        9.3: "83",
        9.4: "83",
        "10.0": "85",
        10.1: "85",
        10.2: "85",
        10.3: "85",
        10.4: "85",
        "11.0": "87",
        11.1: "87",
        11.2: "87",
        11.3: "87",
        11.4: "87",
        11.5: "87",
        "12.0": "89",
        12.1: "89",
        12.2: "89",
        "13.0": "91",
        13.1: "91",
        13.2: "91",
        13.3: "91",
        13.4: "91",
        13.5: "91",
        13.6: "91",
        "14.0": "93",
        14.1: "93",
        14.2: "93",
        "15.0": "94",
        15.1: "94",
        15.2: "94",
        15.3: "94",
        15.4: "94",
        15.5: "94",
        "16.0": "96",
        16.1: "96",
        16.2: "96",
        "17.0": "98",
        17.1: "98",
        17.2: "98",
        17.3: "98",
        17.4: "98",
        "18.0": "100",
        18.1: "100",
        18.2: "100",
        18.3: "100",
        "19.0": "102",
        19.1: "102",
        "20.0": "104",
        20.1: "104",
        20.2: "104",
        20.3: "104",
        "21.0": "106",
        21.1: "106",
        21.2: "106",
        21.3: "106",
        21.4: "106",
        "22.0": "108",
        22.1: "108",
        22.2: "108",
        22.3: "108",
        "23.0": "110",
        23.1: "110",
        23.2: "110",
        23.3: "110",
        "24.0": "112",
        24.1: "112",
        24.2: "112",
        24.3: "112",
        24.4: "112",
        24.5: "112",
        24.6: "112",
        24.7: "112",
        24.8: "112",
        "25.0": "114",
        25.1: "114",
        25.2: "114",
        25.3: "114",
        25.4: "114",
        25.5: "114",
        25.6: "114",
        25.7: "114",
        25.8: "114",
        25.9: "114",
        "26.0": "116",
        26.1: "116",
        26.2: "116",
        26.3: "116",
        26.4: "116",
        26.5: "116",
        26.6: "116",
        "27.0": "118",
        27.1: "118",
        27.2: "118",
        27.3: "118",
        "28.0": "120",
        28.1: "120",
        28.2: "120",
        28.3: "120",
        "29.0": "122",
        29.1: "122",
        29.2: "122",
        29.3: "122",
        29.4: "122",
        "30.0": "124",
        30.1: "124",
        30.2: "124",
        "31.0": "126",
        31.1: "126",
        31.2: "126",
        "32.0": "128",
      };
    },
    768: (module) => {
      "use strict";
      module.exports = require("caniuse-lite/dist/unpacker/agents");
    },
    711: (module) => {
      "use strict";
      module.exports = require("caniuse-lite/dist/unpacker/feature");
    },
    225: (module) => {
      "use strict";
      module.exports = require("caniuse-lite/dist/unpacker/region");
    },
    147: (module) => {
      "use strict";
      module.exports = require("fs");
    },
    17: (module) => {
      "use strict";
      module.exports = require("path");
    },
    750: (module) => {
      "use strict";
      module.exports = JSON.parse(
        '[{"name":"nodejs","version":"0.2.0","date":"2011-08-26","lts":false,"security":false,"v8":"2.3.8.0"},{"name":"nodejs","version":"0.3.0","date":"2011-08-26","lts":false,"security":false,"v8":"2.5.1.0"},{"name":"nodejs","version":"0.4.0","date":"2011-08-26","lts":false,"security":false,"v8":"3.1.2.0"},{"name":"nodejs","version":"0.5.0","date":"2011-08-26","lts":false,"security":false,"v8":"3.1.8.25"},{"name":"nodejs","version":"0.6.0","date":"2011-11-04","lts":false,"security":false,"v8":"3.6.6.6"},{"name":"nodejs","version":"0.7.0","date":"2012-01-17","lts":false,"security":false,"v8":"3.8.6.0"},{"name":"nodejs","version":"0.8.0","date":"2012-06-22","lts":false,"security":false,"v8":"3.11.10.10"},{"name":"nodejs","version":"0.9.0","date":"2012-07-20","lts":false,"security":false,"v8":"3.11.10.15"},{"name":"nodejs","version":"0.10.0","date":"2013-03-11","lts":false,"security":false,"v8":"3.14.5.8"},{"name":"nodejs","version":"0.11.0","date":"2013-03-28","lts":false,"security":false,"v8":"3.17.13.0"},{"name":"nodejs","version":"0.12.0","date":"2015-02-06","lts":false,"security":false,"v8":"3.28.73.0"},{"name":"nodejs","version":"4.0.0","date":"2015-09-08","lts":false,"security":false,"v8":"4.5.103.30"},{"name":"nodejs","version":"4.1.0","date":"2015-09-17","lts":false,"security":false,"v8":"4.5.103.33"},{"name":"nodejs","version":"4.2.0","date":"2015-10-12","lts":"Argon","security":false,"v8":"4.5.103.35"},{"name":"nodejs","version":"4.3.0","date":"2016-02-09","lts":"Argon","security":false,"v8":"4.5.103.35"},{"name":"nodejs","version":"4.4.0","date":"2016-03-08","lts":"Argon","security":false,"v8":"4.5.103.35"},{"name":"nodejs","version":"4.5.0","date":"2016-08-16","lts":"Argon","security":false,"v8":"4.5.103.37"},{"name":"nodejs","version":"4.6.0","date":"2016-09-27","lts":"Argon","security":true,"v8":"4.5.103.37"},{"name":"nodejs","version":"4.7.0","date":"2016-12-06","lts":"Argon","security":false,"v8":"4.5.103.43"},{"name":"nodejs","version":"4.8.0","date":"2017-02-21","lts":"Argon","security":false,"v8":"4.5.103.45"},{"name":"nodejs","version":"4.9.0","date":"2018-03-28","lts":"Argon","security":true,"v8":"4.5.103.53"},{"name":"nodejs","version":"5.0.0","date":"2015-10-29","lts":false,"security":false,"v8":"4.6.85.28"},{"name":"nodejs","version":"5.1.0","date":"2015-11-17","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.2.0","date":"2015-12-09","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.3.0","date":"2015-12-15","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.4.0","date":"2016-01-06","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.5.0","date":"2016-01-21","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.6.0","date":"2016-02-09","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.7.0","date":"2016-02-23","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.8.0","date":"2016-03-09","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.9.0","date":"2016-03-16","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.10.0","date":"2016-04-01","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.11.0","date":"2016-04-21","lts":false,"security":false,"v8":"4.6.85.31"},{"name":"nodejs","version":"5.12.0","date":"2016-06-23","lts":false,"security":false,"v8":"4.6.85.32"},{"name":"nodejs","version":"6.0.0","date":"2016-04-26","lts":false,"security":false,"v8":"5.0.71.35"},{"name":"nodejs","version":"6.1.0","date":"2016-05-05","lts":false,"security":false,"v8":"5.0.71.35"},{"name":"nodejs","version":"6.2.0","date":"2016-05-17","lts":false,"security":false,"v8":"5.0.71.47"},{"name":"nodejs","version":"6.3.0","date":"2016-07-06","lts":false,"security":false,"v8":"5.0.71.52"},{"name":"nodejs","version":"6.4.0","date":"2016-08-12","lts":false,"security":false,"v8":"5.0.71.60"},{"name":"nodejs","version":"6.5.0","date":"2016-08-26","lts":false,"security":false,"v8":"5.1.281.81"},{"name":"nodejs","version":"6.6.0","date":"2016-09-14","lts":false,"security":false,"v8":"5.1.281.83"},{"name":"nodejs","version":"6.7.0","date":"2016-09-27","lts":false,"security":true,"v8":"5.1.281.83"},{"name":"nodejs","version":"6.8.0","date":"2016-10-12","lts":false,"security":false,"v8":"5.1.281.84"},{"name":"nodejs","version":"6.9.0","date":"2016-10-18","lts":"Boron","security":false,"v8":"5.1.281.84"},{"name":"nodejs","version":"6.10.0","date":"2017-02-21","lts":"Boron","security":false,"v8":"5.1.281.93"},{"name":"nodejs","version":"6.11.0","date":"2017-06-06","lts":"Boron","security":false,"v8":"5.1.281.102"},{"name":"nodejs","version":"6.12.0","date":"2017-11-06","lts":"Boron","security":false,"v8":"5.1.281.108"},{"name":"nodejs","version":"6.13.0","date":"2018-02-10","lts":"Boron","security":false,"v8":"5.1.281.111"},{"name":"nodejs","version":"6.14.0","date":"2018-03-28","lts":"Boron","security":true,"v8":"5.1.281.111"},{"name":"nodejs","version":"6.15.0","date":"2018-11-27","lts":"Boron","security":true,"v8":"5.1.281.111"},{"name":"nodejs","version":"6.16.0","date":"2018-12-26","lts":"Boron","security":false,"v8":"5.1.281.111"},{"name":"nodejs","version":"6.17.0","date":"2019-02-28","lts":"Boron","security":true,"v8":"5.1.281.111"},{"name":"nodejs","version":"7.0.0","date":"2016-10-25","lts":false,"security":false,"v8":"5.4.500.36"},{"name":"nodejs","version":"7.1.0","date":"2016-11-08","lts":false,"security":false,"v8":"5.4.500.36"},{"name":"nodejs","version":"7.2.0","date":"2016-11-22","lts":false,"security":false,"v8":"5.4.500.43"},{"name":"nodejs","version":"7.3.0","date":"2016-12-20","lts":false,"security":false,"v8":"5.4.500.45"},{"name":"nodejs","version":"7.4.0","date":"2017-01-04","lts":false,"security":false,"v8":"5.4.500.45"},{"name":"nodejs","version":"7.5.0","date":"2017-01-31","lts":false,"security":false,"v8":"5.4.500.48"},{"name":"nodejs","version":"7.6.0","date":"2017-02-21","lts":false,"security":false,"v8":"5.5.372.40"},{"name":"nodejs","version":"7.7.0","date":"2017-02-28","lts":false,"security":false,"v8":"5.5.372.41"},{"name":"nodejs","version":"7.8.0","date":"2017-03-29","lts":false,"security":false,"v8":"5.5.372.43"},{"name":"nodejs","version":"7.9.0","date":"2017-04-11","lts":false,"security":false,"v8":"5.5.372.43"},{"name":"nodejs","version":"7.10.0","date":"2017-05-02","lts":false,"security":false,"v8":"5.5.372.43"},{"name":"nodejs","version":"8.0.0","date":"2017-05-30","lts":false,"security":false,"v8":"5.8.283.41"},{"name":"nodejs","version":"8.1.0","date":"2017-06-08","lts":false,"security":false,"v8":"5.8.283.41"},{"name":"nodejs","version":"8.2.0","date":"2017-07-19","lts":false,"security":false,"v8":"5.8.283.41"},{"name":"nodejs","version":"8.3.0","date":"2017-08-08","lts":false,"security":false,"v8":"6.0.286.52"},{"name":"nodejs","version":"8.4.0","date":"2017-08-15","lts":false,"security":false,"v8":"6.0.286.52"},{"name":"nodejs","version":"8.5.0","date":"2017-09-12","lts":false,"security":false,"v8":"6.0.287.53"},{"name":"nodejs","version":"8.6.0","date":"2017-09-26","lts":false,"security":false,"v8":"6.0.287.53"},{"name":"nodejs","version":"8.7.0","date":"2017-10-11","lts":false,"security":false,"v8":"6.1.534.42"},{"name":"nodejs","version":"8.8.0","date":"2017-10-24","lts":false,"security":false,"v8":"6.1.534.42"},{"name":"nodejs","version":"8.9.0","date":"2017-10-31","lts":"Carbon","security":false,"v8":"6.1.534.46"},{"name":"nodejs","version":"8.10.0","date":"2018-03-06","lts":"Carbon","security":false,"v8":"6.2.414.50"},{"name":"nodejs","version":"8.11.0","date":"2018-03-28","lts":"Carbon","security":true,"v8":"6.2.414.50"},{"name":"nodejs","version":"8.12.0","date":"2018-09-10","lts":"Carbon","security":false,"v8":"6.2.414.66"},{"name":"nodejs","version":"8.13.0","date":"2018-11-20","lts":"Carbon","security":false,"v8":"6.2.414.72"},{"name":"nodejs","version":"8.14.0","date":"2018-11-27","lts":"Carbon","security":true,"v8":"6.2.414.72"},{"name":"nodejs","version":"8.15.0","date":"2018-12-26","lts":"Carbon","security":false,"v8":"6.2.414.75"},{"name":"nodejs","version":"8.16.0","date":"2019-04-16","lts":"Carbon","security":false,"v8":"6.2.414.77"},{"name":"nodejs","version":"8.17.0","date":"2019-12-17","lts":"Carbon","security":true,"v8":"6.2.414.78"},{"name":"nodejs","version":"9.0.0","date":"2017-10-31","lts":false,"security":false,"v8":"6.2.414.32"},{"name":"nodejs","version":"9.1.0","date":"2017-11-07","lts":false,"security":false,"v8":"6.2.414.32"},{"name":"nodejs","version":"9.2.0","date":"2017-11-14","lts":false,"security":false,"v8":"6.2.414.44"},{"name":"nodejs","version":"9.3.0","date":"2017-12-12","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.4.0","date":"2018-01-10","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.5.0","date":"2018-01-31","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.6.0","date":"2018-02-21","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.7.0","date":"2018-03-01","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.8.0","date":"2018-03-07","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.9.0","date":"2018-03-21","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.10.0","date":"2018-03-28","lts":false,"security":true,"v8":"6.2.414.46"},{"name":"nodejs","version":"9.11.0","date":"2018-04-04","lts":false,"security":false,"v8":"6.2.414.46"},{"name":"nodejs","version":"10.0.0","date":"2018-04-24","lts":false,"security":false,"v8":"6.6.346.24"},{"name":"nodejs","version":"10.1.0","date":"2018-05-08","lts":false,"security":false,"v8":"6.6.346.27"},{"name":"nodejs","version":"10.2.0","date":"2018-05-23","lts":false,"security":false,"v8":"6.6.346.32"},{"name":"nodejs","version":"10.3.0","date":"2018-05-29","lts":false,"security":false,"v8":"6.6.346.32"},{"name":"nodejs","version":"10.4.0","date":"2018-06-06","lts":false,"security":false,"v8":"6.7.288.43"},{"name":"nodejs","version":"10.5.0","date":"2018-06-20","lts":false,"security":false,"v8":"6.7.288.46"},{"name":"nodejs","version":"10.6.0","date":"2018-07-04","lts":false,"security":false,"v8":"6.7.288.46"},{"name":"nodejs","version":"10.7.0","date":"2018-07-18","lts":false,"security":false,"v8":"6.7.288.49"},{"name":"nodejs","version":"10.8.0","date":"2018-08-01","lts":false,"security":false,"v8":"6.7.288.49"},{"name":"nodejs","version":"10.9.0","date":"2018-08-15","lts":false,"security":false,"v8":"6.8.275.24"},{"name":"nodejs","version":"10.10.0","date":"2018-09-06","lts":false,"security":false,"v8":"6.8.275.30"},{"name":"nodejs","version":"10.11.0","date":"2018-09-19","lts":false,"security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.12.0","date":"2018-10-10","lts":false,"security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.13.0","date":"2018-10-30","lts":"Dubnium","security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.14.0","date":"2018-11-27","lts":"Dubnium","security":true,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.15.0","date":"2018-12-26","lts":"Dubnium","security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.16.0","date":"2019-05-28","lts":"Dubnium","security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.17.0","date":"2019-10-22","lts":"Dubnium","security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.18.0","date":"2019-12-17","lts":"Dubnium","security":true,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.19.0","date":"2020-02-05","lts":"Dubnium","security":true,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.20.0","date":"2020-03-26","lts":"Dubnium","security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.21.0","date":"2020-06-02","lts":"Dubnium","security":true,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.22.0","date":"2020-07-21","lts":"Dubnium","security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.23.0","date":"2020-10-27","lts":"Dubnium","security":false,"v8":"6.8.275.32"},{"name":"nodejs","version":"10.24.0","date":"2021-02-23","lts":"Dubnium","security":true,"v8":"6.8.275.32"},{"name":"nodejs","version":"11.0.0","date":"2018-10-23","lts":false,"security":false,"v8":"7.0.276.28"},{"name":"nodejs","version":"11.1.0","date":"2018-10-30","lts":false,"security":false,"v8":"7.0.276.32"},{"name":"nodejs","version":"11.2.0","date":"2018-11-15","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.3.0","date":"2018-11-27","lts":false,"security":true,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.4.0","date":"2018-12-07","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.5.0","date":"2018-12-18","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.6.0","date":"2018-12-26","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.7.0","date":"2019-01-17","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.8.0","date":"2019-01-24","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.9.0","date":"2019-01-30","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.10.0","date":"2019-02-14","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.11.0","date":"2019-03-05","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.12.0","date":"2019-03-14","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.13.0","date":"2019-03-28","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.14.0","date":"2019-04-10","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"11.15.0","date":"2019-04-30","lts":false,"security":false,"v8":"7.0.276.38"},{"name":"nodejs","version":"12.0.0","date":"2019-04-23","lts":false,"security":false,"v8":"7.4.288.21"},{"name":"nodejs","version":"12.1.0","date":"2019-04-29","lts":false,"security":false,"v8":"7.4.288.21"},{"name":"nodejs","version":"12.2.0","date":"2019-05-07","lts":false,"security":false,"v8":"7.4.288.21"},{"name":"nodejs","version":"12.3.0","date":"2019-05-21","lts":false,"security":false,"v8":"7.4.288.27"},{"name":"nodejs","version":"12.4.0","date":"2019-06-04","lts":false,"security":false,"v8":"7.4.288.27"},{"name":"nodejs","version":"12.5.0","date":"2019-06-26","lts":false,"security":false,"v8":"7.5.288.22"},{"name":"nodejs","version":"12.6.0","date":"2019-07-03","lts":false,"security":false,"v8":"7.5.288.22"},{"name":"nodejs","version":"12.7.0","date":"2019-07-23","lts":false,"security":false,"v8":"7.5.288.22"},{"name":"nodejs","version":"12.8.0","date":"2019-08-06","lts":false,"security":false,"v8":"7.5.288.22"},{"name":"nodejs","version":"12.9.0","date":"2019-08-20","lts":false,"security":false,"v8":"7.6.303.29"},{"name":"nodejs","version":"12.10.0","date":"2019-09-04","lts":false,"security":false,"v8":"7.6.303.29"},{"name":"nodejs","version":"12.11.0","date":"2019-09-25","lts":false,"security":false,"v8":"7.7.299.11"},{"name":"nodejs","version":"12.12.0","date":"2019-10-11","lts":false,"security":false,"v8":"7.7.299.13"},{"name":"nodejs","version":"12.13.0","date":"2019-10-21","lts":"Erbium","security":false,"v8":"7.7.299.13"},{"name":"nodejs","version":"12.14.0","date":"2019-12-17","lts":"Erbium","security":true,"v8":"7.7.299.13"},{"name":"nodejs","version":"12.15.0","date":"2020-02-05","lts":"Erbium","security":true,"v8":"7.7.299.13"},{"name":"nodejs","version":"12.16.0","date":"2020-02-11","lts":"Erbium","security":false,"v8":"7.8.279.23"},{"name":"nodejs","version":"12.17.0","date":"2020-05-26","lts":"Erbium","security":false,"v8":"7.8.279.23"},{"name":"nodejs","version":"12.18.0","date":"2020-06-02","lts":"Erbium","security":true,"v8":"7.8.279.23"},{"name":"nodejs","version":"12.19.0","date":"2020-10-06","lts":"Erbium","security":false,"v8":"7.8.279.23"},{"name":"nodejs","version":"12.20.0","date":"2020-11-24","lts":"Erbium","security":false,"v8":"7.8.279.23"},{"name":"nodejs","version":"12.21.0","date":"2021-02-23","lts":"Erbium","security":true,"v8":"7.8.279.23"},{"name":"nodejs","version":"12.22.0","date":"2021-03-30","lts":"Erbium","security":false,"v8":"7.8.279.23"},{"name":"nodejs","version":"13.0.0","date":"2019-10-22","lts":false,"security":false,"v8":"7.8.279.17"},{"name":"nodejs","version":"13.1.0","date":"2019-11-05","lts":false,"security":false,"v8":"7.8.279.17"},{"name":"nodejs","version":"13.2.0","date":"2019-11-21","lts":false,"security":false,"v8":"7.9.317.23"},{"name":"nodejs","version":"13.3.0","date":"2019-12-03","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.4.0","date":"2019-12-17","lts":false,"security":true,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.5.0","date":"2019-12-18","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.6.0","date":"2020-01-07","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.7.0","date":"2020-01-21","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.8.0","date":"2020-02-05","lts":false,"security":true,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.9.0","date":"2020-02-18","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.10.0","date":"2020-03-04","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.11.0","date":"2020-03-12","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.12.0","date":"2020-03-26","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.13.0","date":"2020-04-14","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"13.14.0","date":"2020-04-29","lts":false,"security":false,"v8":"7.9.317.25"},{"name":"nodejs","version":"14.0.0","date":"2020-04-21","lts":false,"security":false,"v8":"8.1.307.30"},{"name":"nodejs","version":"14.1.0","date":"2020-04-29","lts":false,"security":false,"v8":"8.1.307.31"},{"name":"nodejs","version":"14.2.0","date":"2020-05-05","lts":false,"security":false,"v8":"8.1.307.31"},{"name":"nodejs","version":"14.3.0","date":"2020-05-19","lts":false,"security":false,"v8":"8.1.307.31"},{"name":"nodejs","version":"14.4.0","date":"2020-06-02","lts":false,"security":true,"v8":"8.1.307.31"},{"name":"nodejs","version":"14.5.0","date":"2020-06-30","lts":false,"security":false,"v8":"8.3.110.9"},{"name":"nodejs","version":"14.6.0","date":"2020-07-20","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.7.0","date":"2020-07-29","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.8.0","date":"2020-08-11","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.9.0","date":"2020-08-27","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.10.0","date":"2020-09-08","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.11.0","date":"2020-09-15","lts":false,"security":true,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.12.0","date":"2020-09-22","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.13.0","date":"2020-09-29","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.14.0","date":"2020-10-15","lts":false,"security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.15.0","date":"2020-10-27","lts":"Fermium","security":false,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.16.0","date":"2021-02-23","lts":"Fermium","security":true,"v8":"8.4.371.19"},{"name":"nodejs","version":"14.17.0","date":"2021-05-11","lts":"Fermium","security":false,"v8":"8.4.371.23"},{"name":"nodejs","version":"14.18.0","date":"2021-09-28","lts":"Fermium","security":false,"v8":"8.4.371.23"},{"name":"nodejs","version":"14.19.0","date":"2022-02-01","lts":"Fermium","security":false,"v8":"8.4.371.23"},{"name":"nodejs","version":"14.20.0","date":"2022-07-07","lts":"Fermium","security":true,"v8":"8.4.371.23"},{"name":"nodejs","version":"14.21.0","date":"2022-11-01","lts":"Fermium","security":false,"v8":"8.4.371.23"},{"name":"nodejs","version":"15.0.0","date":"2020-10-20","lts":false,"security":false,"v8":"8.6.395.16"},{"name":"nodejs","version":"15.1.0","date":"2020-11-04","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.2.0","date":"2020-11-10","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.3.0","date":"2020-11-24","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.4.0","date":"2020-12-09","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.5.0","date":"2020-12-22","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.6.0","date":"2021-01-14","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.7.0","date":"2021-01-25","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.8.0","date":"2021-02-02","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.9.0","date":"2021-02-18","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.10.0","date":"2021-02-23","lts":false,"security":true,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.11.0","date":"2021-03-03","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.12.0","date":"2021-03-17","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.13.0","date":"2021-03-31","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"15.14.0","date":"2021-04-06","lts":false,"security":false,"v8":"8.6.395.17"},{"name":"nodejs","version":"16.0.0","date":"2021-04-20","lts":false,"security":false,"v8":"9.0.257.17"},{"name":"nodejs","version":"16.1.0","date":"2021-05-04","lts":false,"security":false,"v8":"9.0.257.24"},{"name":"nodejs","version":"16.2.0","date":"2021-05-19","lts":false,"security":false,"v8":"9.0.257.25"},{"name":"nodejs","version":"16.3.0","date":"2021-06-03","lts":false,"security":false,"v8":"9.0.257.25"},{"name":"nodejs","version":"16.4.0","date":"2021-06-23","lts":false,"security":false,"v8":"9.1.269.36"},{"name":"nodejs","version":"16.5.0","date":"2021-07-14","lts":false,"security":false,"v8":"9.1.269.38"},{"name":"nodejs","version":"16.6.0","date":"2021-07-29","lts":false,"security":true,"v8":"9.2.230.21"},{"name":"nodejs","version":"16.7.0","date":"2021-08-18","lts":false,"security":false,"v8":"9.2.230.21"},{"name":"nodejs","version":"16.8.0","date":"2021-08-25","lts":false,"security":false,"v8":"9.2.230.21"},{"name":"nodejs","version":"16.9.0","date":"2021-09-07","lts":false,"security":false,"v8":"9.3.345.16"},{"name":"nodejs","version":"16.10.0","date":"2021-09-22","lts":false,"security":false,"v8":"9.3.345.19"},{"name":"nodejs","version":"16.11.0","date":"2021-10-08","lts":false,"security":false,"v8":"9.4.146.19"},{"name":"nodejs","version":"16.12.0","date":"2021-10-20","lts":false,"security":false,"v8":"9.4.146.19"},{"name":"nodejs","version":"16.13.0","date":"2021-10-26","lts":"Gallium","security":false,"v8":"9.4.146.19"},{"name":"nodejs","version":"16.14.0","date":"2022-02-08","lts":"Gallium","security":false,"v8":"9.4.146.24"},{"name":"nodejs","version":"16.15.0","date":"2022-04-26","lts":"Gallium","security":false,"v8":"9.4.146.24"},{"name":"nodejs","version":"16.16.0","date":"2022-07-07","lts":"Gallium","security":true,"v8":"9.4.146.24"},{"name":"nodejs","version":"16.17.0","date":"2022-08-16","lts":"Gallium","security":false,"v8":"9.4.146.26"},{"name":"nodejs","version":"16.18.0","date":"2022-10-12","lts":"Gallium","security":false,"v8":"9.4.146.26"},{"name":"nodejs","version":"16.19.0","date":"2022-12-13","lts":"Gallium","security":false,"v8":"9.4.146.26"},{"name":"nodejs","version":"16.20.0","date":"2023-03-28","lts":"Gallium","security":false,"v8":"9.4.146.26"},{"name":"nodejs","version":"17.0.0","date":"2021-10-19","lts":false,"security":false,"v8":"9.5.172.21"},{"name":"nodejs","version":"17.1.0","date":"2021-11-09","lts":false,"security":false,"v8":"9.5.172.25"},{"name":"nodejs","version":"17.2.0","date":"2021-11-30","lts":false,"security":false,"v8":"9.6.180.14"},{"name":"nodejs","version":"17.3.0","date":"2021-12-17","lts":false,"security":false,"v8":"9.6.180.15"},{"name":"nodejs","version":"17.4.0","date":"2022-01-18","lts":false,"security":false,"v8":"9.6.180.15"},{"name":"nodejs","version":"17.5.0","date":"2022-02-10","lts":false,"security":false,"v8":"9.6.180.15"},{"name":"nodejs","version":"17.6.0","date":"2022-02-22","lts":false,"security":false,"v8":"9.6.180.15"},{"name":"nodejs","version":"17.7.0","date":"2022-03-09","lts":false,"security":false,"v8":"9.6.180.15"},{"name":"nodejs","version":"17.8.0","date":"2022-03-22","lts":false,"security":false,"v8":"9.6.180.15"},{"name":"nodejs","version":"17.9.0","date":"2022-04-07","lts":false,"security":false,"v8":"9.6.180.15"},{"name":"nodejs","version":"18.0.0","date":"2022-04-18","lts":false,"security":false,"v8":"10.1.124.8"},{"name":"nodejs","version":"18.1.0","date":"2022-05-03","lts":false,"security":false,"v8":"10.1.124.8"},{"name":"nodejs","version":"18.2.0","date":"2022-05-17","lts":false,"security":false,"v8":"10.1.124.8"},{"name":"nodejs","version":"18.3.0","date":"2022-06-02","lts":false,"security":false,"v8":"10.2.154.4"},{"name":"nodejs","version":"18.4.0","date":"2022-06-16","lts":false,"security":false,"v8":"10.2.154.4"},{"name":"nodejs","version":"18.5.0","date":"2022-07-06","lts":false,"security":true,"v8":"10.2.154.4"},{"name":"nodejs","version":"18.6.0","date":"2022-07-13","lts":false,"security":false,"v8":"10.2.154.13"},{"name":"nodejs","version":"18.7.0","date":"2022-07-26","lts":false,"security":false,"v8":"10.2.154.13"},{"name":"nodejs","version":"18.8.0","date":"2022-08-24","lts":false,"security":false,"v8":"10.2.154.13"},{"name":"nodejs","version":"18.9.0","date":"2022-09-07","lts":false,"security":false,"v8":"10.2.154.15"},{"name":"nodejs","version":"18.10.0","date":"2022-09-28","lts":false,"security":false,"v8":"10.2.154.15"},{"name":"nodejs","version":"18.11.0","date":"2022-10-13","lts":false,"security":false,"v8":"10.2.154.15"},{"name":"nodejs","version":"18.12.0","date":"2022-10-25","lts":"Hydrogen","security":false,"v8":"10.2.154.15"},{"name":"nodejs","version":"18.13.0","date":"2023-01-05","lts":"Hydrogen","security":false,"v8":"10.2.154.23"},{"name":"nodejs","version":"18.14.0","date":"2023-02-01","lts":"Hydrogen","security":false,"v8":"10.2.154.23"},{"name":"nodejs","version":"18.15.0","date":"2023-03-05","lts":"Hydrogen","security":false,"v8":"10.2.154.26"},{"name":"nodejs","version":"18.16.0","date":"2023-04-12","lts":"Hydrogen","security":false,"v8":"10.2.154.26"},{"name":"nodejs","version":"18.17.0","date":"2023-07-18","lts":"Hydrogen","security":false,"v8":"10.2.154.26"},{"name":"nodejs","version":"18.18.0","date":"2023-09-18","lts":"Hydrogen","security":false,"v8":"10.2.154.26"},{"name":"nodejs","version":"18.19.0","date":"2023-11-29","lts":"Hydrogen","security":false,"v8":"10.2.154.26"},{"name":"nodejs","version":"19.0.0","date":"2022-10-17","lts":false,"security":false,"v8":"10.7.193.13"},{"name":"nodejs","version":"19.1.0","date":"2022-11-14","lts":false,"security":false,"v8":"10.7.193.20"},{"name":"nodejs","version":"19.2.0","date":"2022-11-29","lts":false,"security":false,"v8":"10.8.168.20"},{"name":"nodejs","version":"19.3.0","date":"2022-12-14","lts":false,"security":false,"v8":"10.8.168.21"},{"name":"nodejs","version":"19.4.0","date":"2023-01-05","lts":false,"security":false,"v8":"10.8.168.25"},{"name":"nodejs","version":"19.5.0","date":"2023-01-24","lts":false,"security":false,"v8":"10.8.168.25"},{"name":"nodejs","version":"19.6.0","date":"2023-02-01","lts":false,"security":false,"v8":"10.8.168.25"},{"name":"nodejs","version":"19.7.0","date":"2023-02-21","lts":false,"security":false,"v8":"10.8.168.25"},{"name":"nodejs","version":"19.8.0","date":"2023-03-14","lts":false,"security":false,"v8":"10.8.168.25"},{"name":"nodejs","version":"19.9.0","date":"2023-04-10","lts":false,"security":false,"v8":"10.8.168.25"},{"name":"nodejs","version":"20.0.0","date":"2023-04-17","lts":false,"security":false,"v8":"11.3.244.4"},{"name":"nodejs","version":"20.1.0","date":"2023-05-03","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.2.0","date":"2023-05-16","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.3.0","date":"2023-06-08","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.4.0","date":"2023-07-04","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.5.0","date":"2023-07-19","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.6.0","date":"2023-08-23","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.7.0","date":"2023-09-18","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.8.0","date":"2023-09-28","lts":false,"security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.9.0","date":"2023-10-24","lts":"Iron","security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"20.10.0","date":"2023-11-22","lts":"Iron","security":false,"v8":"11.3.244.8"},{"name":"nodejs","version":"21.0.0","date":"2023-10-17","lts":false,"security":false,"v8":"11.8.172.13"},{"name":"nodejs","version":"21.1.0","date":"2023-10-24","lts":false,"security":false,"v8":"11.8.172.15"},{"name":"nodejs","version":"21.2.0","date":"2023-11-14","lts":false,"security":false,"v8":"11.8.172.17"},{"name":"nodejs","version":"21.3.0","date":"2023-11-30","lts":false,"security":false,"v8":"11.8.172.17"}]',
      );
    },
    629: (module) => {
      "use strict";
      module.exports = JSON.parse(
        '{"v0.8":{"start":"2012-06-25","end":"2014-07-31"},"v0.10":{"start":"2013-03-11","end":"2016-10-31"},"v0.12":{"start":"2015-02-06","end":"2016-12-31"},"v4":{"start":"2015-09-08","lts":"2015-10-12","maintenance":"2017-04-01","end":"2018-04-30","codename":"Argon"},"v5":{"start":"2015-10-29","maintenance":"2016-04-30","end":"2016-06-30"},"v6":{"start":"2016-04-26","lts":"2016-10-18","maintenance":"2018-04-30","end":"2019-04-30","codename":"Boron"},"v7":{"start":"2016-10-25","maintenance":"2017-04-30","end":"2017-06-30"},"v8":{"start":"2017-05-30","lts":"2017-10-31","maintenance":"2019-01-01","end":"2019-12-31","codename":"Carbon"},"v9":{"start":"2017-10-01","maintenance":"2018-04-01","end":"2018-06-30"},"v10":{"start":"2018-04-24","lts":"2018-10-30","maintenance":"2020-05-19","end":"2021-04-30","codename":"Dubnium"},"v11":{"start":"2018-10-23","maintenance":"2019-04-22","end":"2019-06-01"},"v12":{"start":"2019-04-23","lts":"2019-10-21","maintenance":"2020-11-30","end":"2022-04-30","codename":"Erbium"},"v13":{"start":"2019-10-22","maintenance":"2020-04-01","end":"2020-06-01"},"v14":{"start":"2020-04-21","lts":"2020-10-27","maintenance":"2021-10-19","end":"2023-04-30","codename":"Fermium"},"v15":{"start":"2020-10-20","maintenance":"2021-04-01","end":"2021-06-01"},"v16":{"start":"2021-04-20","lts":"2021-10-26","maintenance":"2022-10-18","end":"2023-09-11","codename":"Gallium"},"v17":{"start":"2021-10-19","maintenance":"2022-04-01","end":"2022-06-01"},"v18":{"start":"2022-04-19","lts":"2022-10-25","maintenance":"2023-10-18","end":"2025-04-30","codename":"Hydrogen"},"v19":{"start":"2022-10-18","maintenance":"2023-04-01","end":"2023-06-01"},"v20":{"start":"2023-04-18","lts":"2023-10-24","maintenance":"2024-10-22","end":"2026-04-30","codename":"Iron"},"v21":{"start":"2023-10-17","maintenance":"2024-04-01","end":"2024-06-01"},"v22":{"start":"2024-04-23","lts":"2024-10-29","maintenance":"2025-10-21","end":"2027-04-30","codename":""},"v23":{"start":"2024-10-15","maintenance":"2025-04-01","end":"2025-06-01"},"v24":{"start":"2025-04-22","lts":"2025-10-28","maintenance":"2026-10-20","end":"2028-04-30","codename":""}}',
      );
    },
  };
  var __webpack_module_cache__ = {};
  function __nccwpck_require__(moduleId) {
    var cachedModule = __webpack_module_cache__[moduleId];
    if (cachedModule !== undefined) {
      return cachedModule.exports;
    }
    var module = (__webpack_module_cache__[moduleId] = { exports: {} });
    var threw = true;
    try {
      __webpack_modules__[moduleId](
        module,
        module.exports,
        __nccwpck_require__,
      );
      threw = false;
    } finally {
      if (threw) delete __webpack_module_cache__[moduleId];
    }
    return module.exports;
  }
  if (typeof __nccwpck_require__ !== "undefined")
    __nccwpck_require__.ab = __dirname + "/";
  var __webpack_exports__ = __nccwpck_require__(80);
  module.exports = __webpack_exports__;
})();
