# 本地包配置说明

## 概述

为了解决内网环境下某些包安装失败的问题，我们将这些包下载到本地 `packages` 目录，并通过 `file:` 路径直接引用本地包。

## 包含的包

### 核心依赖包
- `unrs-resolver@1.11.1` - Rust相关的解析器包
- `eslint-import-context@0.1.9` - ESLint导入上下文插件
- `@rsbuild/plugin-image-compress@1.1.0` - Rsbuild图片压缩插件

### Rsbuild 相关包
- `@rsbuild/core@1.0.1-beta.9` - Rsbuild 核心包
- `@rsbuild/plugin-less@1.0.1-beta.9` - Less 插件
- `@rsbuild/plugin-react@1.0.1-beta.9` - React 插件
- `@rsbuild/plugin-svgr@1.0.1-beta.9` - SVGR 插件
- `@rsbuild/plugin-typed-css-modules@1.0.1-beta.9` - CSS 模块类型插件

### ESLint 相关包
- `eslint@9.0.0` - ESLint 核心
- `eslint-plugin-react-hooks@4.6.0` - React Hooks 规则
- `eslint-plugin-react-refresh@0.4.4` - React Refresh 规则
- `@eslint/compat@9.0.0` - ESLint 兼容性包
- `@eslint-react/eslint-plugin@1.5.8` - React ESLint 插件
- `@antfu/eslint-config@3.0.0` - Antfu ESLint 配置

### Rspack 相关包
- `@rspack/core@1.0.0-beta.1` - Rspack 核心
- `@rspack/binding@1.0.0-beta.1` - Rspack 绑定包
- `@rspack-core/*` - Rspack 核心模块

## 配置方式

在 `package.json` 中直接引用本地包：

```json
{
  "dependencies": {
    "unrs-resolver": "file:packages/unrs-resolver",
    "eslint-import-context": "file:packages/eslint-import-context",
    "@rsbuild/plugin-image-compress": "file:packages/@rsbuild/plugin-image-compress"
  }
}
```

## 使用方法

### 内网环境（推荐）
1. 确保 `packages` 目录中包含所需的包
2. 直接运行 `npm run dev` 启动项目
3. 项目会自动使用本地包，无需重新安装

### 如果需要重新安装依赖
```bash
# 清理之前的安装
rm -rf node_modules
rm -f package-lock.json

# 安装依赖（会使用本地包）
npm install --no-optional --legacy-peer-deps
```

## 优势

- **完全离线**：不需要网络连接
- **版本固定**：确保使用特定版本
- **快速启动**：不需要下载和编译
- **可控性强**：完全控制包的来源
- **即开即用**：包已下载，直接可用

## 注意事项

- 这些包是可选依赖，跳过它们不会影响项目正常运行
- 如果需要更新包版本，需要手动下载新版本到 `packages` 目录
- 建议将 `packages` 目录加入版本控制，确保团队环境一致
- 项目已经配置好，可以直接使用 `npm run dev` 启动

## 问题修复记录

### 2024-08-14: 修复 @scripts/test-helper 依赖问题
- **问题**: 内网环境安装时报错 `@scripts/test-helper@1.0.1-beta.9` 包在 registry 中找不到
- **原因**: 该包是 `@rsbuild` 插件的开发依赖，在内网 registry 中不可用
- **解决方案**: 从 `@rsbuild/plugin-react`、`@rsbuild/plugin-less`、`@rsbuild/plugin-svgr` 的 `package.json` 中移除 `@scripts/test-helper` 依赖
- **影响**: 由于是开发依赖，移除后不影响生产构建和项目运行
