/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 381:
/***/ (function(__unused_webpack_module, exports, __nccwpck_require__) {


var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isValidationErrorLike = exports.isValidationError = exports.toValidationError = exports.fromZodError = exports.ValidationError = void 0;
const zod = __importStar(__nccwpck_require__(934));
const joinPath_1 = __nccwpck_require__(954);
const NonEmptyArray_1 = __nccwpck_require__(978);
class ValidationError extends Error {
    details;
    name;
    constructor(message, details = []) {
        super(message);
        this.details = details;
        this.name = 'ZodValidationError';
    }
    toString() {
        return this.message;
    }
}
exports.ValidationError = ValidationError;
function fromZodIssue(issue, issueSeparator, unionSeparator) {
    if (issue.code === 'invalid_union') {
        return issue.unionErrors
            .reduce((acc, zodError) => {
            const newIssues = zodError.issues
                .map((issue) => fromZodIssue(issue, issueSeparator, unionSeparator))
                .join(issueSeparator);
            if (!acc.includes(newIssues)) {
                acc.push(newIssues);
            }
            return acc;
        }, [])
            .join(unionSeparator);
    }
    if ((0, NonEmptyArray_1.isNonEmptyArray)(issue.path)) {
        if (issue.path.length === 1) {
            const identifier = issue.path[0];
            if (typeof identifier === 'number') {
                return `${issue.message} at index ${identifier}`;
            }
        }
        return `${issue.message} at "${(0, joinPath_1.joinPath)(issue.path)}"`;
    }
    return issue.message;
}
function fromZodError(zodError, options = {}) {
    const { maxIssuesInMessage = 99, issueSeparator = '; ', unionSeparator = ', or ', prefixSeparator = ': ', prefix = 'Validation error', } = options;
    const reason = zodError.errors
        .slice(0, maxIssuesInMessage)
        .map((issue) => fromZodIssue(issue, issueSeparator, unionSeparator))
        .join(issueSeparator);
    const message = reason ? [prefix, reason].join(prefixSeparator) : prefix;
    return new ValidationError(message, zodError.errors);
}
exports.fromZodError = fromZodError;
const toValidationError = (options = {}) => (err) => {
    if (err instanceof zod.ZodError) {
        return fromZodError(err, options);
    }
    if (err instanceof Error) {
        return err;
    }
    return new Error('Unknown error');
};
exports.toValidationError = toValidationError;
function isValidationError(err) {
    return err instanceof ValidationError;
}
exports.isValidationError = isValidationError;
function isValidationErrorLike(err) {
    return err instanceof Error && err.name === 'ZodValidationError';
}
exports.isValidationErrorLike = isValidationErrorLike;


/***/ }),

/***/ 978:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isNonEmptyArray = void 0;
function isNonEmptyArray(value) {
    return value.length !== 0;
}
exports.isNonEmptyArray = isNonEmptyArray;


/***/ }),

/***/ 954:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.joinPath = void 0;
const identifierRegex = /[$_\p{ID_Start}][$\u200c\u200d\p{ID_Continue}]*/u;
function joinPath(path) {
    if (path.length === 1) {
        return path[0].toString();
    }
    return path.reduce((acc, item) => {
        if (typeof item === 'number') {
            return acc + '[' + item.toString() + ']';
        }
        if (item.includes('"')) {
            return acc + '["' + escapeQuotes(item) + '"]';
        }
        if (!identifierRegex.test(item)) {
            return acc + '["' + item + '"]';
        }
        const separator = acc.length === 0 ? '' : '.';
        return acc + separator + item;
    }, '');
}
exports.joinPath = joinPath;
function escapeQuotes(str) {
    return str.replace(/"/g, '\\"');
}


/***/ }),

/***/ 934:
/***/ ((module) => {

module.exports = require("../zod");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __nccwpck_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		var threw = true;
/******/ 		try {
/******/ 			__webpack_modules__[moduleId].call(module.exports, module, module.exports, __nccwpck_require__);
/******/ 			threw = false;
/******/ 		} finally {
/******/ 			if(threw) delete __webpack_module_cache__[moduleId];
/******/ 		}
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat */
/******/ 	
/******/ 	if (typeof __nccwpck_require__ !== 'undefined') __nccwpck_require__.ab = __dirname + "/";
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
var exports = __webpack_exports__;

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fromZodError = exports.isValidationErrorLike = exports.isValidationError = exports.toValidationError = exports.ValidationError = void 0;
var ValidationError_1 = __nccwpck_require__(381);
Object.defineProperty(exports, "ValidationError", ({ enumerable: true, get: function () { return ValidationError_1.ValidationError; } }));
Object.defineProperty(exports, "toValidationError", ({ enumerable: true, get: function () { return ValidationError_1.toValidationError; } }));
Object.defineProperty(exports, "isValidationError", ({ enumerable: true, get: function () { return ValidationError_1.isValidationError; } }));
Object.defineProperty(exports, "isValidationErrorLike", ({ enumerable: true, get: function () { return ValidationError_1.isValidationErrorLike; } }));
Object.defineProperty(exports, "fromZodError", ({ enumerable: true, get: function () { return ValidationError_1.fromZodError; } }));

})();

module.exports = __webpack_exports__;
/******/ })()
;