import * as zod from 'zod';

declare class ValidationError extends Error {
    details: Array<zod.ZodIssue>;
    name: 'ZodValidationError';
    constructor(message: string, details?: Array<zod.ZodIssue> | undefined);
    toString(): string;
}
type ZodError = zod.ZodError;
type FromZodErrorOptions = {
    maxIssuesInMessage?: number;
    issueSeparator?: string;
    unionSeparator?: string;
    prefixSeparator?: string;
    prefix?: string;
};
declare function fromZodError(zodError: ZodError, options?: FromZodErrorOptions): ValidationError;
declare const toValidationError: (options?: Parameters<typeof fromZodError>[1]) => (err: unknown) => ValidationError | Error;
declare function isValidationError(err: unknown): err is ValidationError;
declare function isValidationErrorLike(err: unknown): err is ValidationError;

export { type FromZodErrorOptions, ValidationError, type ZodError, fromZodError, isValidationError, isValidationErrorLike, toValidationError };
