import type { IncomingMessage, ServerResponse } from 'node:http';
import type { Compiler, MultiCompiler } from '@rspack/core';
import type { DevMiddlewareOptions } from '../provider/createCompiler';
import type { NextFunction } from '../types';
type ServerCallbacks = {
    onInvalid: (compilationName?: string) => void;
    onDone: (stats: any) => void;
};
export declare const isClientCompiler: (compiler: {
    options: {
        target?: Compiler["options"]["target"];
    };
}) => boolean;
export declare const setupServerHooks: (compiler: Compiler, hookCallbacks: ServerCallbacks) => void;
export type Middleware = (req: IncomingMessage, res: ServerResponse, next: NextFunction) => Promise<void>;
export type DevMiddlewareAPI = Middleware & {
    close: (callback: (err: Error | null | undefined) => void) => any;
};
/**
 * The rsbuild/server do nothing about compiler, the devMiddleware need do such things to ensure dev works well:
 * - Call compiler.watch （normally did by webpack-dev-middleware）.
 * - Inject the hmr client path into page （the hmr client rsbuild/server already provide）.
 * - Notify server when compiler hooks are triggered.
 */
export type DevMiddleware = (options: DevMiddlewareOptions) => DevMiddlewareAPI;
export declare const getDevMiddleware: (multiCompiler: Compiler | MultiCompiler) => Promise<NonNullable<DevMiddleware>>;
export {};
