import React from 'react'
import { motion } from 'framer-motion'
import { Button, Tooltip } from '@nextui-org/react'
import { NavBarDivider } from '../NavBarDivider'
import styles from './NavBarItem.module.less'
import Logo from '@/assets/svg/logo.svg?react'

interface NavBarItemProps {
  onClick: (key: string) => void
  icon: React.FunctionComponent<React.SVGProps<SVGSVGElement>> | string
  label: string
  type: string
}
export const NavBarItem: React.FC<NavBarItemProps> = ({ onClick, icon, label, type }) => {
  if (label === '' && icon === '') {
    return <NavBarDivider />
  }
  if (label === '' && icon !== '') {
    return (
      <motion.div className="nav-logo">
        <Logo />
      </motion.div>
    )
  }
  return (
    <motion.div className={`${styles.NavBarItem}`}>
      <div className={`${styles.icon}`}>
        <Tooltip color="foreground" content={label} placement="right">
          <Button onClick={() => onClick(type)} variant="light" isIconOnly aria-label="Like">
            {React.createElement(icon)}
          </Button>
        </Tooltip>
      </div>
      {/* <div className={styles.label}>{label}</div> */}
    </motion.div>
  )
}
