import React from 'react'
import { Button, Checkbox, Link, Modal, ModalBody, ModalContent, ModalFooter, ModalHeader } from '@nextui-org/react'
import { useAuth } from '@/auth/AuthContext'

interface LoginModalProps {
  isOpen: boolean
  onClose: () => void
}

export const LoginModal: React.FC<LoginModalProps> = ({ isOpen, onClose }) => {
  const { login } = useAuth()

  const [isSelected, setIsSelected] = React.useState(false)

  const handleLogin = () => {
    login()
  }
  return (
    <Modal backdrop="blur" isOpen={isOpen} onClose={onClose}>
      <ModalContent>
        {onClose => (
          <>
            <ModalHeader className="flex flex-col gap-1">欢迎您使用晓得AI助手</ModalHeader>
            <ModalBody className="text-[#27353C]">
              <p>
                为帮助您更好了解晓得AI 助手服务内容，保障您的合法权益。
              </p>
              <p>
                请您认真阅读
                <Link showAnchorIcon underline="hover">《服务协议》</Link>
                <Link showAnchorIcon underline="hover">《隐私政策》</Link>
                ，特别是其中有关使用限制、免责声明、个人信息保护等内容。
              </p>
              <p>
                您需在仔细阅读并确认同意相关协议后方可使用本服务。
              </p>
              <p>
                <Checkbox
                  isSelected={isSelected}
                  onValueChange={setIsSelected}
                >
                  我已阅读并同意
                </Checkbox>
              </p>
            </ModalBody>
            <ModalFooter>
              <Button onPress={onClose}>
                再想想
              </Button>
              <Button isDisabled={!isSelected} color="primary" onPress={handleLogin}>
                同意
              </Button>
            </ModalFooter>
          </>
        )}
      </ModalContent>
    </Modal>
  )
}
