import './App.css'
import React from 'react'
import { BrowserRouter as Router } from 'react-router-dom'
import { MainLayout } from './layouts'
import { AppRoutes } from './routes/AppRoutes'
import { AuthProvider } from './auth/AuthContext'
import ToastWrapper from './components/ToastWrapper/ToastWrapper'

const App: React.FC = () => {
  return (
    <ToastWrapper>
      <AuthProvider>
        <Router>
          <MainLayout>
            <AppRoutes />
          </MainLayout>
        </Router>
      </AuthProvider>
    </ToastWrapper>
  )
}

export default App
