// Vue 3 项目中使用 SDK 的示例
import { createSimpleSDK } from '../index'

// 1. 在 Vue 组件中使用
export function useSDK() {
  const sdk = createSimpleSDK({
    apiBaseUrl: 'https://api.example.com',
    apiKey: 'your-api-key',
  })

  const handleClick = () => {
    sdk.showAlert('Hello from Vue 3!')
  }

  return {
    handleClick,
    sdk,
  }
}

// 2. 在组合式 API 中使用
export function setupSDK() {
  const sdk = createSimpleSDK({
    apiBaseUrl: 'https://api.example.com',
    apiKey: 'your-api-key',
  })

  return {
    sdk,
  }
}
