#!/bin/bash

# SDK 复制到其他项目的脚本

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${GREEN}SDK 复制到其他项目脚本${NC}"
echo "================================"

# 检查参数
if [ $# -eq 0 ]; then
    echo -e "${RED}错误: 请提供目标项目路径${NC}"
    echo "用法: ./copy-to-project.sh /path/to/target/project"
    exit 1
fi

TARGET_PROJECT=$1
SDK_PATH="/Users/liu/Documents/zkr/vue3-simple-project/src/sdk"

# 检查目标项目是否存在
if [ ! -d "$TARGET_PROJECT" ]; then
    echo -e "${RED}错误: 目标项目路径不存在: $TARGET_PROJECT${NC}"
    exit 1
fi

# 检查 SDK 路径是否存在
if [ ! -d "$SDK_PATH" ]; then
    echo -e "${RED}错误: SDK 路径不存在: $SDK_PATH${NC}"
    exit 1
fi

# 创建目标目录
TARGET_SDK_PATH="$TARGET_PROJECT/src/sdk"
mkdir -p "$TARGET_SDK_PATH"

# 复制文件
echo -e "${YELLOW}正在复制 SDK 文件...${NC}"
cp -r "$SDK_PATH"/* "$TARGET_SDK_PATH/"

# 检查复制是否成功
if [ $? -eq 0 ]; then
    echo -e "${GREEN}✅ SDK 复制成功！${NC}"
    echo -e "${GREEN}目标路径: $TARGET_SDK_PATH${NC}"
    echo ""
    echo -e "${YELLOW}在目标项目中使用:${NC}"
    echo "import { createSimpleSDK } from './sdk';"
    echo ""
    echo -e "${YELLOW}示例代码:${NC}"
    echo "const sdk = createSimpleSDK({"
    echo "  apiBaseUrl: 'https://api.example.com',"
    echo "  apiKey: 'your-api-key'"
    echo "});"
else
    echo -e "${RED}❌ SDK 复制失败！${NC}"
    exit 1
fi
