import { formatMarkdown } from './markdownFormatter'
import { ChatAnswerAttachment } from './ChatAnswerAttchment'
import { ChatAnswerOperate } from './ChatAnswerOperate'
import type { Answer } from '@/types/chat'
import { MarkdownDetail } from '@/components/MarkdownDetail'

interface ChatAnswerShowerProps {
  answer: Answer
}

export const ChatAnswerShower: React.FC<ChatAnswerShowerProps> = ({ answer }) => {
  return (
    <div className="answerShower">
      <MarkdownDetail>
        {formatMarkdown(answer.answer || '')}
      </MarkdownDetail>
      {/* <ReactMarkdown
        rehypePlugins={[rehypeRaw, rehypeSanitize]}
        remarkPlugins={[remarkGfm]}
        className="markdown-content"
      >
        {formatMarkdown(answer.answer || '')}
      </ReactMarkdown> */}

      {answer.attachmentList && answer.attachmentList?.length !== 0 && <ChatAnswerAttachment answer={answer} />}
      <ChatAnswerOperate answer={answer} />
    </div>
  )
}
