import { Avatar } from '@heroui/react'
import { motion } from 'framer-motion'
import AvatarBot from '@/assets/avatarBot.png'
import AIIcon from '@/assets/ai-icon.png'

interface ChatWelcomeProps {
  toolName?: string
}

export const ChatWelcome: React.FC<ChatWelcomeProps> = ({ toolName: _toolName }) => {
   const viteOutputObj = import.meta.env.VITE_OUTPUT_OBJ || 'open'

  // 根据不同的 toolName 显示不同的提示语
  const getWelcomeText = () => {
    const currentToolId = typeof window !== 'undefined' ? sessionStorage.getItem('currentToolId') : ''

    if (currentToolId === '6712395743240') {
      return 'Hi~我是您的数据助手，可以帮你查询业务数据哦'
    }

    if (currentToolId === '6712395743241') {
      return 'Hi，我是AI提质增效助手，可以为您解答研发需求计划和业务功能流程等相关问题。请问有什么可以帮您？'
    }

    return 'Hi，我是AI制度活化助手，可以为您提供公司规章制度、政策条款的查询与解读服务。请问您想了解什么呢？'
  }

  return (
    <div className="chatWelcomeContainer w-full">
      <div className="h-[20px] sm:h-[32px] w-full"></div>
      <div className="flex items-start">
        <Avatar className="mr-[12px] flex-shrink-0" src={viteOutputObj === 'inner' ? AIIcon : AvatarBot} />
        <motion.div
          className="rounded-[20px] box-border px-[16px] py-[16px] sm:px-[24px] sm:py-[20px]"
          style={{ background: '#F7FAFD' }}
        >
          <div className="content">
            <p
              className="font-medium text-[#333]"
              style={{ fontSize: '16px' }}
            >
              {getWelcomeText()}
            </p>
            {/* <p className="text-[15px] mt-[4px]  sm:mt-[8px] sm:text-13px text-[#27353C] font-300">作为您的智能保险伙伴，您有各类专业相关的问题都可以抛给我哟~让我们互相帮助共同成长吧~</p> */}
          </div>
        </motion.div>
      </div>
      <div className="h-[20px] sm:h-[32px] w-full"></div>
    </div>
  )
}
