import type { PayloadAction } from '@reduxjs/toolkit'
import { createSlice } from '@reduxjs/toolkit'

interface ChatSlice {
  isAsking: boolean
}

const initialState: ChatSlice = {
  isAsking: false,
}

const chatSlice = createSlice({
  name: 'chatSlice',
  initialState,
  reducers: {
    setIsAsking: (state, action: PayloadAction<boolean>) => {
      state.isAsking = action.payload
    },
  },
})

export const { setIsAsking } = chatSlice.actions

export default chatSlice.reducer
