import { toString } from './base'

export const isDef = <T = any>(val?: T): val is T => typeof val !== 'undefined'
export const isBoolean = (val: any): val is boolean => typeof val === 'boolean'
// eslint-disable-next-line ts/no-unsafe-function-type
export const isFunction = <T extends Function> (val: any): val is T => typeof val === 'function'
export const isNumber = (val: any): val is number => typeof val === 'number'
export const isString = (val: unknown): val is string => typeof val === 'string'
export const isObject = (val: any): val is object => toString(val) === '[object Object]'
export const isUndefined = (val: any): val is undefined => toString(val) === '[object Undefined]'
export const isNull = (val: any): val is null => toString(val) === '[object Null]'
export const isRegExp = (val: any): val is RegExp => toString(val) === '[object RegExp]'
export const isDate = (val: any): val is Date => toString(val) === '[object Date]'

export const isWindow = (val: any): boolean => typeof window !== 'undefined' && toString(val) === '[object Window]'
export const isBrowser = typeof window !== 'undefined'
/**
 * 判断当前设备是否为移动端
 * @returns {boolean} true 表示移动端，false 表示 PC 端
 */
export function isMobile(): boolean {
  // 1. 使用 navigator.userAgent 进行判断
  const userAgent = navigator.userAgent.toLowerCase()

  // 2. 定义移动设备的关键词
  const mobileKeywords = [
    'mobile',
    'android',
    'iphone',
    'ipod',
    'ipad',
    'windows phone',
    'webos',
    'blackberry',
  ]

  // 3. 检查是否包含移动设备关键词
  const isMobileDevice = mobileKeywords.some(keyword => userAgent.includes(keyword))

  // 4. 使用屏幕宽度作为补充判断（可选）
  const isMobileWidth = window.innerWidth <= 768

  // 5. 返回结果：同时满足 UA 判断和屏幕宽度判断才认为是移动端
  return isMobileDevice && isMobileWidth
}
