import type { ChatRecord, OriginalRecord } from '@/types/chat'

export function processApiResponse(data: OriginalRecord[]): ChatRecord[] {
  const chatRecord: ChatRecord[] = []
  if (data.length === 0)
    return chatRecord
  data.forEach((record) => {
    // 如果没有 question 字段（后端未返回问题文案），则不生成用户问题气泡，避免展示“空气炮”
    if (record.question) {
      chatRecord.push({
        role: 'user',
        ...record,
      })
    }

    if (record.answerList && record.answerList.length > 0) {
      record.answerList.forEach((answer) => {
        answer.isShow = true
      })
      chatRecord.push({
        role: 'ai',
        answerList: record.answerList,
        question: record.question,
        toolId: record.toolId,
      })
    }
  })

  return chatRecord
}
