# SVGR 插件

默认情况下，Rsbuild 会将 SVG 图片当作静态资源处理，处理规则可参考：引用静态资源。

通过添加 SVGR 插件，Rsbuild 支持调用 SVGR，将 SVG 图片转换为一个 React 组件使用。

# 安装插件

```bash
pnpm add @rsbuild/plugin-svgr -D
```

# 注册插件

```ts
// rsbuild.config.ts
import { pluginSvgr } from '@rsbuild/plugin-svgr'

export default {
  plugins: [pluginSvgr()],
}
```

# 示例

注册插件后，当你在 JS 文件中引用 SVG 资源时，如果导入的路径包含 ?react 后缀，Rsbuild 会调用 SVGR，将 SVG 图片转换为一个 React 组件。

```tsx
import Logo from './logo.svg?react'

export const App = () => <Logo />
```

如果导入的路径不包含 ?react 后缀，那么 SVG 会被当做普通的静态资源来处理，你会得到一个 URL 字符串：

```tsx
import logoURL from './static/logo.svg'

console.log(logoURL) // => "/static/logo.6c12aba3.png"
```

Rsbuild 也支持具名导入 ReactComponent 来使用 SVGR：

```tsx
import { ReactComponent as Logo } from './logo.svg'

export const App = () => <Logo />
```
