import { Avatar } from '@nextui-org/react'
import AvatarUser from '@/assets/avatarUser.png'
import type { ChatRecord } from '@/types/chat'

interface ChatItemUserProps {
  record: ChatRecord
}

export const ChatItemUser: React.FC<ChatItemUserProps> = ({ record }) => {
  return (
    <div className="chatItemUser">
      <div className="flex justify-end">
        <div className="mr-[20px] bg-[#BFE9FE] rounded-[20px] box-border px-[24px] py-[20px] text-[#27353C]">{record.question}</div>
        <Avatar className="flex-shrink-0" src={AvatarUser} />
      </div>
      <div className="h-[32px] w-full"></div>
    </div>
  )
}
