import { AnimatePresence, motion } from 'framer-motion'
import { Button, Input, Modal, ModalBody, ModalContent, ModalFooter, ModalHeader, Table, TableBody, TableCell, TableColumn, TableHeader, TableRow } from '@nextui-org/react'
import React, { useState } from 'react'
import { variants } from './motionAnimate'
import { HistoryBarList } from './components/HistoryBarList'
import SearchIcon from '@/assets/svg/search.svg?react'
import HistoryMenuIcon from '@/assets/svg/historyMenu.svg?react'

interface HistoryBarProps {
  isVisible: boolean
}

export const HistoryBar: React.FC<HistoryBarProps> = ({ isVisible }) => {
  // const [isSelected, setIsSelected] = useState(false)
  const [isOpen, setIsOpen] = useState(false)
  return (
    <AnimatePresence>
      {isVisible && (
        <motion.div
          initial="hidden"
          animate="visible"
          exit="exit"
          variants={variants}
          className="w-[252px] rounded-[20px] sm:h-[80vh] sm:max-h-[800px] bg-[#F0FAFF] border-[1px] border-solid border-white ml-[12px]"
        >
          <div className="pt-[24px] flex flex-col h-full">
            <div className="px-[32px] h-[40px]">
              <Input classNames={{ inputWrapper: ['bg-white', 'data-[hover=true]:bg-[#fff]', 'group-data-[focus=true]:bg-white', 'rounded-[24px]'] }} placeholder="搜索历史记录" startContent={<SearchIcon />} />
            </div>
            <div className="px-[32px] flex-1 overflow-y-auto">
              <HistoryBarList />
            </div>
            <div className="text-[12px] border-t-solid border-t-[1px] border-t-[#82969C12] w-full h-[48px] flex items-center justify-center">
              <Button onClick={() => setIsOpen(true)} className="w-full" color="primary" variant="light" startContent={<HistoryMenuIcon />}>
                <span className="text-[#82969C]">管理对话记录</span>
              </Button>
            </div>
          </div>
          <Modal backdrop="blur" size="3xl" isOpen={isOpen} onClose={() => setIsOpen(false)}>
            <ModalContent>
              {onClose => (
                <>
                  <ModalHeader className="flex flex-col gap-1">
                    <div>
                      管理对话记录
                      <span className="text-[#8D9795] text-[14px]">（共11条）</span>
                    </div>
                  </ModalHeader>
                  <ModalBody className="text-[#27353C]">
                    <Table
                      removeWrapper
                      selectionMode="multiple"
                      defaultSelectedKeys={[]}
                      aria-label="Example static collection table"
                    >
                      <TableHeader>
                        <TableColumn>NAME</TableColumn>
                        <TableColumn>ROLE</TableColumn>
                        <TableColumn>STATUS</TableColumn>
                      </TableHeader>
                      <TableBody>
                        <TableRow key="1">
                          <TableCell>Tony Reichert</TableCell>
                          <TableCell>CEO</TableCell>
                          <TableCell>Active</TableCell>
                        </TableRow>
                        <TableRow key="2">
                          <TableCell>Zoey Lang</TableCell>
                          <TableCell>Technical Lead</TableCell>
                          <TableCell>Paused</TableCell>
                        </TableRow>
                        <TableRow key="3">
                          <TableCell>Jane Fisher</TableCell>
                          <TableCell>Senior Developer</TableCell>
                          <TableCell>Active</TableCell>
                        </TableRow>
                        <TableRow key="4">
                          <TableCell>William Howard</TableCell>
                          <TableCell>Community Manager</TableCell>
                          <TableCell>Vacation</TableCell>
                        </TableRow>
                      </TableBody>
                    </Table>
                  </ModalBody>
                  <ModalFooter>
                    <Button onPress={onClose}>
                      取消
                    </Button>
                    <Button color="primary">
                      删除所选
                    </Button>
                  </ModalFooter>
                </>
              )}
            </ModalContent>
          </Modal>
        </motion.div>
      )}
    </AnimatePresence>
  )
}
