import type React from 'react'
import TextLogo from '@/assets/svg/textLogo.svg?react'
import { GradientsBall } from '@/components/GradientsBall/GradientsBall'
import TypewriterEFfect from '@/components/TypewriterEffect'

export const Slogan: React.FC = () => {
  const words = [
    {
      text: '晓得解惑，让沟通',
    },
    {
      text: '更智能.',
      className: 'bg-clip-text text-transparent bg-gradient-to-br from-cyan-400 via-blue-600 to-purple-500',
    },
  ]
  return (
    <div className="flex flex-col items-center box-border">
      <GradientsBall />
      <TextLogo className="w-[80px] sm:w-auto" />
      {/* <GradualSpacing text="晓得解惑，让沟通更智能" className="mt-[20px] text-[18px] sm:mt-[36px] text-[#333] sm:text-[28px] font-medium" /> */}
      <TypewriterEFfect cursorClassName="!h-[14px] !w-[2px] sm:!w-[4px] sm:!h-[22px] !bg-[#29B6FD]/40" className="mt-[8px] text-[18px] sm:mt-[12px] text-[#333] sm:text-[28px] font-medium" words={words} />
      {/* <h2 className="mt-[20px] text-[18px] sm:mt-[36px] text-[#333] sm:text-[28px] font-medium">晓得解惑，让沟通更智能</h2> */}
      <h3 className="mt-[8px] text-[14px] text-center sm:text-[18px] text-[#5AA9D0] font-light sm:mt-[16px]">知晓市场脉搏，引领行业潮流，晓得AI助手全方位为您保驾护航</h3>
    </div>
  )
}
