import React, { useEffect } from 'react'
import { useLocation } from 'react-router-dom'
import { clearCurrentConversation, setCurrentConversation } from '@/store/conversationSlice'
import { useAppDispatch } from '@/store/hook'

export function withRouteChangeHandler(WrappedComponent: React.ComponentType) {
  return (props: any) => {
    const location = useLocation()
    const dispatch = useAppDispatch()

    useEffect(() => {
      if (location.pathname === '/') {
        dispatch(clearCurrentConversation())
      }
      else if (location.pathname.startsWith('/chat/')) {
        const conversationId = location.pathname.split('/')[2]
        dispatch(setCurrentConversation(conversationId))
      }
      // 这里可以添加其他路由相关的逻辑
    }, [location, dispatch])

    return <WrappedComponent {...props} />
  }
}
