import React from 'react'
import { Route, Routes } from 'react-router-dom'
import { Home } from '../pages/Home'
import { Chat } from '../pages/Chat'
import { withRouteChangeHandler } from './RouteChangeHandler'

const AppRoutesComponent: React.FC = () => {
  return (
    <Routes>
      <Route path="/" element={<Home />} />
      <Route path="/chat/:id" element={<Chat />} />
    </Routes>
  )
}

export const AppRoutes = withRouteChangeHandler(AppRoutesComponent)
