import { Avatar } from '@nextui-org/react'
import { motion } from 'framer-motion'
import ReactMarkdown from 'react-markdown'
import rehypeRaw from 'rehype-raw'
import rehypeSanitize from 'rehype-sanitize'
import { formatMarkdown } from './markdownFormatter'
import AvatarBot from '@/assets/avatarBot.png'
import type { ChatRecord } from '@/types/chat'

interface ChatItemBotProps {
  record: ChatRecord
}

export const ChatItemBot: React.FC<ChatItemBotProps> = ({ record }) => {
  return (
    <div className="chatItemBotContainer w-full">
      <div className="flex">
        <Avatar className="flex-shrink-0" src={AvatarBot} />
        <motion.div
          className="ml-[20px] bg-white rounded-[20px] box-border px-[24px] py-[20px]"
        >
          <div className="content">
            <ReactMarkdown
              rehypePlugins={[rehypeRaw, rehypeSanitize]}
              className="markdown-content"
            >
              {formatMarkdown(record.originalData?.answerList[0].answer || '')}
            </ReactMarkdown>
          </div>
        </motion.div>
        <div className="w-[130px]"></div>
      </div>
      <div className="h-[32px] w-full"></div>
    </div>
  )
}
