import { Button } from '@nextui-org/react'
import type { Answer } from '@/types/chat'
import AnswerProDetailIcon from '@/assets/svg/answerProDetail.svg?react'
import LinkIcon from '@/assets/svg/link.svg?react'

interface ChatAnswerAttachmentProps {
  answer: Answer
}
export const ChatAnswerAttachment: React.FC<ChatAnswerAttachmentProps> = ({ answer }) => {
  const handleReferenceLink = (link: string) => {
    window.open(link)
  }
  return (
    <div className="attachmentList flex flex-col gap-[20px] mt-[20px]">
      {answer.attachmentList && answer.attachmentList.map((attachment, index) => (
        <div key={`${attachment.type}_${index}`}>

          {/* 附件：product-detail */}
          {attachment.type === 'product-detail' && (
            <div className="bg-[#29B6FD0A] text-[14px] text-primary py-[4px] px-[16px] w-fit flex items-center">
              <AnswerProDetailIcon />
              {/* <span className="ml-[6px]">{attachment.name}</span> */}
              <div className="ml-[6px] w-[120px] sm:w-full text-nowrap text-ellipsis overflow-hidden">
                {attachment.name}
              </div>
            </div>
          )}

          {/* 附件：引用文件 */}
          {attachment.type === 'reference' && (
            <div>
              <p className="text-[14px] text-[#8D9795] mb-[12px] pl-[14px]">
                已为您找到
                {attachment.content.docList.length}
                篇资料作为参考
              </p>
              <div className="flex flex-col gap-[12px]">
                { attachment.content.docList.map(doc => (
                  <Button onClick={() => handleReferenceLink(doc.docId)} key={doc.docId} color="primary" variant="light" className="text-left bg-[#F6F6F8] w-fit text-[#333] rounded-[8px] data-[hover=true]:bg-[#E5F6FF] data-[hover=true]:text-primary">
                    <LinkIcon />
                    <div className="w-[150px] sm:w-full text-nowrap text-ellipsis overflow-hidden">
                      {doc.docName}
                    </div>
                  </Button>
                ))}
              </div>
            </div>

          )}
        </div>
      ))}
    </div>
  )
}
